//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_ValueItemDefinition_h
#define pybind_attribute_ValueItemDefinition_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/ValueItemDefinition.h"

namespace py = pybind11;

py::class_<smtk::attribute::ValueItemDefinition, std::shared_ptr<smtk::attribute::ValueItemDefinition> >
pybind11_init_smtk_attribute_ValueItemDefinition(py::module &m, py::class_<smtk::attribute::ItemDefinition, std::shared_ptr<smtk::attribute::ItemDefinition> >& parent)
{
  py::class_<smtk::attribute::ValueItemDefinition, std::shared_ptr<smtk::attribute::ValueItemDefinition> > instance(m, "ValueItemDefinition", parent);
  instance
    .def_property("isExtensible", &smtk::attribute::ValueItemDefinition::isExtensible, &smtk::attribute::ValueItemDefinition::setIsExtensible)
    .def_property("maxNumberOfValues", &smtk::attribute::ValueItemDefinition::maxNumberOfValues, &smtk::attribute::ValueItemDefinition::setMaxNumberOfValues)
    .def_property("expressionDefinition", &smtk::attribute::ValueItemDefinition::expressionDefinition, &smtk::attribute::ValueItemDefinition::setExpressionDefinition)
    .def_property("numberOfRequiredValues", &smtk::attribute::ValueItemDefinition::numberOfRequiredValues, &smtk::attribute::ValueItemDefinition::setNumberOfRequiredValues)
    .def_property("valueLabel", &smtk::attribute::ValueItemDefinition::valueLabel, &smtk::attribute::ValueItemDefinition::setValueLabel)
    .def_property("units", &smtk::attribute::ValueItemDefinition::units, &smtk::attribute::ValueItemDefinition::setUnits)
    .def_property("defaultDiscreteIndex", &smtk::attribute::ValueItemDefinition::defaultDiscreteIndex, &smtk::attribute::ValueItemDefinition::setDefaultDiscreteIndex)
    .def("addChildItemDefinition", &smtk::attribute::ValueItemDefinition::addChildItemDefinition, py::arg("cdef"))
    .def("addConditionalItem", &smtk::attribute::ValueItemDefinition::addConditionalItem, py::arg("enumValue"), py::arg("itemName"))
    .def("allowsExpressions", &smtk::attribute::ValueItemDefinition::allowsExpressions)
    .def("buildChildrenItems", &smtk::attribute::ValueItemDefinition::buildChildrenItems, py::arg("vitem"))
    .def("buildExpressionItem", &smtk::attribute::ValueItemDefinition::buildExpressionItem, py::arg("vitem"), py::arg("position"))
    .def("childrenItemDefinitions", &smtk::attribute::ValueItemDefinition::childrenItemDefinitions)
    .def("classname", &smtk::attribute::ValueItemDefinition::classname)
    .def("conditionalItems", &smtk::attribute::ValueItemDefinition::conditionalItems, py::arg("enumValue"))
    .def("discreteEnum", &smtk::attribute::ValueItemDefinition::discreteEnum, py::arg("ith"))
    .def("hasChildItemDefinition", (bool (smtk::attribute::ValueItemDefinition::*)(::std::string const &) const) &smtk::attribute::ValueItemDefinition::hasChildItemDefinition)
    .def("hasChildItemDefinition", (bool (smtk::attribute::ValueItemDefinition::*)(::std::string const &, ::std::string const &)) &smtk::attribute::ValueItemDefinition::hasChildItemDefinition)
    .def("hasDefault", &smtk::attribute::ValueItemDefinition::hasDefault)
    .def("hasRange", &smtk::attribute::ValueItemDefinition::hasRange)
    .def("hasValueLabels", &smtk::attribute::ValueItemDefinition::hasValueLabels)
    .def("isDiscrete", &smtk::attribute::ValueItemDefinition::isDiscrete)
    .def("isDiscreteIndexValid", &smtk::attribute::ValueItemDefinition::isDiscreteIndexValid, py::arg("index"))
    .def("isValidExpression", &smtk::attribute::ValueItemDefinition::isValidExpression, py::arg("exp"))
    .def("numberOfChildrenItemDefinitions", &smtk::attribute::ValueItemDefinition::numberOfChildrenItemDefinitions)
    .def("numberOfDiscreteValues", &smtk::attribute::ValueItemDefinition::numberOfDiscreteValues)
    .def("setCommonValueLabel", &smtk::attribute::ValueItemDefinition::setCommonValueLabel, py::arg("elabel"))
    .def("usingCommonLabel", &smtk::attribute::ValueItemDefinition::usingCommonLabel)
    ;
  return instance;
}

#endif
