//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_TimeZone_h
#define pybind_attribute_TimeZone_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/TimeZone.h"

namespace py = pybind11;

PySharedPtrClass< smtk::attribute::TimeZone > pybind11_init_smtk_attribute_TimeZone(py::module &m)
{
  PySharedPtrClass< smtk::attribute::TimeZone > instance(m, "TimeZone");
  instance
    .def(py::init<>())
    .def(py::init<::smtk::attribute::TimeZone const &>())
    .def("deepcopy", (smtk::attribute::TimeZone & (smtk::attribute::TimeZone::*)(::smtk::attribute::TimeZone const &)) &smtk::attribute::TimeZone::operator=)
    .def_property("region", &smtk::attribute::TimeZone::region, &smtk::attribute::TimeZone::setRegion)
    .def_property("posixString", &smtk::attribute::TimeZone::posixString, &smtk::attribute::TimeZone::setPosixString)
    .def("isSet", &smtk::attribute::TimeZone::isSet)
    //.def("posixString", &smtk::attribute::TimeZone::posixString)
    .def("stdZoneName", &smtk::attribute::TimeZone::stdZoneName)
    .def("stdZoneAbbreviation", &smtk::attribute::TimeZone::stdZoneAbbreviation)
    .def("dstZoneName", &smtk::attribute::TimeZone::dstZoneName)
    .def("dstZoneAbbreviation", &smtk::attribute::TimeZone::dstZoneAbbreviation)
    .def("hasDST", &smtk::attribute::TimeZone::hasDST)
    //.def("utcOffset", &smtk::attribute::TimeZone::utcOffset, py::arg("hours"), py::arg("minutes"))
    //.def("dstShift", &smtk::attribute::TimeZone::dstShift, py::arg("hours"), py::arg("minutes"))

    // Modified methods (return tuple for args passed in by reference)
    .def("utcOffset",
         [](const smtk::attribute::TimeZone &tz) {
         int hour=-1, minute=-1;
         tz.utcOffset(hour, minute);
         return std::make_tuple(hour, minute);
         })
    .def("dstShift",
         [](const smtk::attribute::TimeZone &tz) {
         int hour=-1, minute=-1;
         tz.dstShift(hour, minute);
         return std::make_tuple(hour, minute);
         })
    ;
  return instance;
}

#endif
