//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_ModelEntityItemDefinition_h
#define pybind_attribute_ModelEntityItemDefinition_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/ModelEntityItemDefinition.h"
#include "smtk/attribute/ItemDefinition.h"

#include "smtk/attribute/Attribute.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_ModelEntityItemDefinition(py::module &m, py::class_<smtk::attribute::ItemDefinition, std::shared_ptr<smtk::attribute::ItemDefinition> >& parent)
{
  py::class_<smtk::attribute::ModelEntityItemDefinition, std::shared_ptr<smtk::attribute::ModelEntityItemDefinition> > instance(m, "ModelEntityItemDefinition", parent);
  instance
    .def(py::init<::smtk::attribute::ModelEntityItemDefinition const &>())
    .def_property("membershipMask", &smtk::attribute::ModelEntityItemDefinition::membershipMask, &smtk::attribute::ModelEntityItemDefinition::setMembershipMask)
    .def_property("numberOfRequiredValues", &smtk::attribute::ModelEntityItemDefinition::numberOfRequiredValues, &smtk::attribute::ModelEntityItemDefinition::setNumberOfRequiredValues)
    .def_property("valueLabel", &smtk::attribute::ModelEntityItemDefinition::valueLabel, &smtk::attribute::ModelEntityItemDefinition::setValueLabel)
    .def_property("isExtensible", &smtk::attribute::ModelEntityItemDefinition::isExtensible, &smtk::attribute::ModelEntityItemDefinition::setIsExtensible)
    .def_property("maxNumberOfValues", &smtk::attribute::ModelEntityItemDefinition::maxNumberOfValues, &smtk::attribute::ModelEntityItemDefinition::setMaxNumberOfValues)
    .def_static("New", &smtk::attribute::ModelEntityItemDefinition::New, py::arg("sname"))
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::ModelEntityItemDefinition::*)(::smtk::attribute::Attribute *, int) const) &smtk::attribute::ModelEntityItemDefinition::buildItem)
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::ModelEntityItemDefinition::*)(::smtk::attribute::Item *, int, int) const) &smtk::attribute::ModelEntityItemDefinition::buildItem)
    .def("classname", &smtk::attribute::ModelEntityItemDefinition::classname)
    .def("createCopy", &smtk::attribute::ModelEntityItemDefinition::createCopy, py::arg("info"))
    .def("hasValueLabels", &smtk::attribute::ModelEntityItemDefinition::hasValueLabels)
    .def("isValueValid", &smtk::attribute::ModelEntityItemDefinition::isValueValid, py::arg("entity"))
    .def("setCommonValueLabel", &smtk::attribute::ModelEntityItemDefinition::setCommonValueLabel, py::arg("elabel"))
    .def("type", &smtk::attribute::ModelEntityItemDefinition::type)
    .def("usingCommonLabel", &smtk::attribute::ModelEntityItemDefinition::usingCommonLabel)
    .def_static("ToItemDefinition", [](const std::shared_ptr<smtk::attribute::ModelEntityItemDefinition> d) {
        return std::dynamic_pointer_cast<smtk::attribute::ItemDefinition>(d);
      })
    .def_static("CastTo", [](const std::shared_ptr<smtk::attribute::ItemDefinition> i) {
        return std::dynamic_pointer_cast<smtk::attribute::ModelEntityItemDefinition>(i);
      })
    ;
}

#endif
