//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_ModelEntityItem_h
#define pybind_attribute_ModelEntityItem_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/ModelEntityItem.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_ModelEntityItem(py::module &m, py::class_<smtk::attribute::Item, std::shared_ptr<smtk::attribute::Item> >& parent)
{
  py::class_<smtk::attribute::ModelEntityItem, std::shared_ptr<smtk::attribute::ModelEntityItem> > instance(m, "ModelEntityItem", parent);
  instance
    .def(py::init<::smtk::attribute::ModelEntityItem const &>())
    .def("deepcopy", (smtk::attribute::ModelEntityItem & (smtk::attribute::ModelEntityItem::*)(::smtk::attribute::ModelEntityItem const &)) &smtk::attribute::ModelEntityItem::operator=)
    .def_property("numberOfValues", &smtk::attribute::ModelEntityItem::numberOfValues, &smtk::attribute::ModelEntityItem::setNumberOfValues)
    .def("appendValue", &smtk::attribute::ModelEntityItem::appendValue, py::arg("val"))
    .def("assign", &smtk::attribute::ModelEntityItem::assign, py::arg("sourceItem"), py::arg("options") = 0)
    .def("begin", &smtk::attribute::ModelEntityItem::begin)
    .def("classname", &smtk::attribute::ModelEntityItem::classname)
    .def("end", &smtk::attribute::ModelEntityItem::end)
    .def("find", (ptrdiff_t (smtk::attribute::ModelEntityItem::*)(::smtk::common::UUID const &) const) &smtk::attribute::ModelEntityItem::find)
    .def("find", (ptrdiff_t (smtk::attribute::ModelEntityItem::*)(::smtk::model::EntityRef const &) const) &smtk::attribute::ModelEntityItem::find)
    .def("has", (bool (smtk::attribute::ModelEntityItem::*)(::smtk::common::UUID const &) const) &smtk::attribute::ModelEntityItem::has)
    .def("has", (bool (smtk::attribute::ModelEntityItem::*)(::smtk::model::EntityRef const &) const) &smtk::attribute::ModelEntityItem::has)
    .def("isExtensible", &smtk::attribute::ModelEntityItem::isExtensible)
    .def("isSet", &smtk::attribute::ModelEntityItem::isSet, py::arg("element") = 0)
    .def("isValid", &smtk::attribute::ModelEntityItem::isValid)
    .def("numberOfRequiredValues", &smtk::attribute::ModelEntityItem::numberOfRequiredValues)
    .def("removeValue", &smtk::attribute::ModelEntityItem::removeValue, py::arg("element"))
    .def("reset", &smtk::attribute::ModelEntityItem::reset)
    .def("setValue", (bool (smtk::attribute::ModelEntityItem::*)(::smtk::model::EntityRef const &)) &smtk::attribute::ModelEntityItem::setValue)
    .def("setValue", (bool (smtk::attribute::ModelEntityItem::*)(::size_t, ::smtk::model::EntityRef const &)) &smtk::attribute::ModelEntityItem::setValue)
    .def("type", &smtk::attribute::ModelEntityItem::type)
    .def("unset", &smtk::attribute::ModelEntityItem::unset, py::arg("element") = 0)
    .def("value", &smtk::attribute::ModelEntityItem::value, py::arg("element") = 0)
    .def("valueAsString", (std::string (smtk::attribute::ModelEntityItem::*)() const) &smtk::attribute::ModelEntityItem::valueAsString)
    .def("valueAsString", (std::string (smtk::attribute::ModelEntityItem::*)(::size_t) const) &smtk::attribute::ModelEntityItem::valueAsString)
    .def_static("CastTo", [](const std::shared_ptr<smtk::attribute::Item> i) {
        return std::dynamic_pointer_cast<smtk::attribute::ModelEntityItem>(i);
      })
    ;
}

#endif
