//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_MeshItem_h
#define pybind_attribute_MeshItem_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/MeshItem.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_MeshItem(py::module &m, py::class_<smtk::attribute::Item, std::shared_ptr<smtk::attribute::Item> >& parent)
{
  py::class_<smtk::attribute::MeshItem, std::shared_ptr<smtk::attribute::MeshItem> > instance(m, "MeshItem", parent);
  instance
    .def(py::init<::smtk::attribute::MeshItem const &>())
    .def("deepcopy", (smtk::attribute::MeshItem & (smtk::attribute::MeshItem::*)(::smtk::attribute::MeshItem const &)) &smtk::attribute::MeshItem::operator=)
    .def_property("numberOfValues", &smtk::attribute::MeshItem::numberOfValues, &smtk::attribute::MeshItem::setNumberOfValues)
    .def("appendValue", &smtk::attribute::MeshItem::appendValue, py::arg("arg0"))
    .def("appendValues", (bool (smtk::attribute::MeshItem::*)(::smtk::mesh::MeshList const &)) &smtk::attribute::MeshItem::appendValues)
    .def("appendValues", (bool (smtk::attribute::MeshItem::*)(::smtk::mesh::MeshSets const &)) &smtk::attribute::MeshItem::appendValues)
    .def("assign", &smtk::attribute::MeshItem::assign, py::arg("sourceItem"), py::arg("options") = 0)
    .def("begin", &smtk::attribute::MeshItem::begin)
    .def("classname", &smtk::attribute::MeshItem::classname)
    .def("end", &smtk::attribute::MeshItem::end)
    .def("find", &smtk::attribute::MeshItem::find, py::arg("mesh"))
    .def("hasValue", &smtk::attribute::MeshItem::hasValue, py::arg("arg0"))
    .def("isExtensible", &smtk::attribute::MeshItem::isExtensible)
    .def("isSet", &smtk::attribute::MeshItem::isSet, py::arg("element") = 0)
    .def("isValid", &smtk::attribute::MeshItem::isValid)
    .def("numberOfRequiredValues", &smtk::attribute::MeshItem::numberOfRequiredValues)
    .def("removeValue", &smtk::attribute::MeshItem::removeValue, py::arg("element"))
    .def("reset", &smtk::attribute::MeshItem::reset)
    .def("setValue", (bool (smtk::attribute::MeshItem::*)(::smtk::mesh::MeshSet const &)) &smtk::attribute::MeshItem::setValue)
    .def("setValue", (bool (smtk::attribute::MeshItem::*)(::size_t, ::smtk::mesh::MeshSet const &)) &smtk::attribute::MeshItem::setValue)
    .def("type", &smtk::attribute::MeshItem::type)
    .def("unset", &smtk::attribute::MeshItem::unset, py::arg("element") = 0)
    .def("value", &smtk::attribute::MeshItem::value, py::arg("element") = 0)
    .def("values", &smtk::attribute::MeshItem::values)
    ;
}

#endif
