//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_ItemDefinition_h
#define pybind_attribute_ItemDefinition_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/ItemDefinition.h"

namespace py = pybind11;

py::class_<smtk::attribute::ItemDefinition, std::shared_ptr<smtk::attribute::ItemDefinition> >
pybind11_init_smtk_attribute_ItemDefinition(py::module &m)
{
  py::class_<smtk::attribute::ItemDefinition, std::shared_ptr<smtk::attribute::ItemDefinition> > instance(m, "ItemDefinition");
  instance
    .def_property("briefDescription", &smtk::attribute::ItemDefinition::briefDescription, &smtk::attribute::ItemDefinition::setBriefDescription)
    .def_property("detailedDescription", &smtk::attribute::ItemDefinition::detailedDescription, &smtk::attribute::ItemDefinition::setDetailedDescription)
    .def_property("isEnabledByDefault", &smtk::attribute::ItemDefinition::isEnabledByDefault, &smtk::attribute::ItemDefinition::setIsEnabledByDefault)
    .def_property("isOptional", &smtk::attribute::ItemDefinition::isOptional, &smtk::attribute::ItemDefinition::setIsOptional)
    .def_property("version", &smtk::attribute::ItemDefinition::version, &smtk::attribute::ItemDefinition::setVersion)
    .def_property("label", &smtk::attribute::ItemDefinition::label, &smtk::attribute::ItemDefinition::setLabel)
    .def("addCategory", &smtk::attribute::ItemDefinition::addCategory, py::arg("category"))
    .def("advanceLevel", &smtk::attribute::ItemDefinition::advanceLevel, py::arg("mode") = 0)
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::ItemDefinition::*)(::smtk::attribute::Attribute *, int) const) &smtk::attribute::ItemDefinition::buildItem)
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::ItemDefinition::*)(::smtk::attribute::Item *, int, int) const) &smtk::attribute::ItemDefinition::buildItem)
    .def("categories", &smtk::attribute::ItemDefinition::categories)
    .def("classname", &smtk::attribute::ItemDefinition::classname)
    .def("createCopy", &smtk::attribute::ItemDefinition::createCopy, py::arg("info"))
    .def("isMemberOf", (bool (smtk::attribute::ItemDefinition::*)(::std::string const &) const) &smtk::attribute::ItemDefinition::isMemberOf)
    .def("isMemberOf", (bool (smtk::attribute::ItemDefinition::*)(::std::vector<std::basic_string<char>, std::allocator<std::basic_string<char> > > const &) const) &smtk::attribute::ItemDefinition::isMemberOf)
    .def("name", &smtk::attribute::ItemDefinition::name)
    .def("numberOfCategories", &smtk::attribute::ItemDefinition::numberOfCategories)
    .def("removeCategory", &smtk::attribute::ItemDefinition::removeCategory, py::arg("category"))
    .def("setAdvanceLevel", (void (smtk::attribute::ItemDefinition::*)(int, int)) &smtk::attribute::ItemDefinition::setAdvanceLevel)
    .def("setAdvanceLevel", (void (smtk::attribute::ItemDefinition::*)(int)) &smtk::attribute::ItemDefinition::setAdvanceLevel)
    .def("type", &smtk::attribute::ItemDefinition::type)
    ;
  return instance;
}

#endif
