//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_GroupItem_h
#define pybind_attribute_GroupItem_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/GroupItem.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_GroupItem(py::module &m, py::class_<smtk::attribute::Item, std::shared_ptr<smtk::attribute::Item> >& parent)
{
  py::class_<smtk::attribute::GroupItem, std::shared_ptr<smtk::attribute::GroupItem> > instance(m, "GroupItem", parent);
  instance
    .def(py::init<::smtk::attribute::GroupItem const &>())
    .def("deepcopy", (smtk::attribute::GroupItem & (smtk::attribute::GroupItem::*)(::smtk::attribute::GroupItem const &)) &smtk::attribute::GroupItem::operator=)
    .def_property("numberOfGroups", &smtk::attribute::GroupItem::numberOfGroups, &smtk::attribute::GroupItem::setNumberOfGroups)
    .def("appendGroup", &smtk::attribute::GroupItem::appendGroup)
    .def("assign", &smtk::attribute::GroupItem::assign, py::arg("sourceItem"), py::arg("options") = 0)
    .def("begin", &smtk::attribute::GroupItem::begin)
    .def("classname", &smtk::attribute::GroupItem::classname)
    .def("end", &smtk::attribute::GroupItem::end)
    .def("find", (smtk::attribute::ItemPtr (smtk::attribute::GroupItem::*)(::std::string const &)) &smtk::attribute::GroupItem::find)
    .def("find", (smtk::attribute::ItemPtr (smtk::attribute::GroupItem::*)(::size_t, ::std::string const &)) &smtk::attribute::GroupItem::find)
    .def("find", (smtk::attribute::ConstItemPtr (smtk::attribute::GroupItem::*)(::std::string const &) const) &smtk::attribute::GroupItem::find)
    .def("find", (smtk::attribute::ConstItemPtr (smtk::attribute::GroupItem::*)(::size_t, ::std::string const &) const) &smtk::attribute::GroupItem::find)
    .def("isExtensible", &smtk::attribute::GroupItem::isExtensible)
    .def("isValid", &smtk::attribute::GroupItem::isValid)
    .def("item", (smtk::attribute::ItemPtr (smtk::attribute::GroupItem::*)(::size_t) const) &smtk::attribute::GroupItem::item)
    .def("item", (smtk::attribute::ItemPtr (smtk::attribute::GroupItem::*)(::size_t, ::size_t) const) &smtk::attribute::GroupItem::item)
    .def("maxNumberOfGroups", &smtk::attribute::GroupItem::maxNumberOfGroups)
    .def("numberOfItemsPerGroup", &smtk::attribute::GroupItem::numberOfItemsPerGroup)
    .def("numberOfRequiredGroups", &smtk::attribute::GroupItem::numberOfRequiredGroups)
    .def("removeGroup", &smtk::attribute::GroupItem::removeGroup, py::arg("element"))
    .def("reset", &smtk::attribute::GroupItem::reset)
    .def("type", &smtk::attribute::GroupItem::type)
    .def_static("CastTo", [](const std::shared_ptr<smtk::attribute::Item> i) {
        return std::dynamic_pointer_cast<smtk::attribute::GroupItem>(i);
      })
    ;
}

#endif
