//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_FileSystemItemDefinition_h
#define pybind_attribute_FileSystemItemDefinition_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/FileSystemItemDefinition.h"

namespace py = pybind11;

py::class_<smtk::attribute::FileSystemItemDefinition, std::shared_ptr<smtk::attribute::FileSystemItemDefinition> >
pybind11_init_smtk_attribute_FileSystemItemDefinition(py::module &m, py::class_<smtk::attribute::ItemDefinition, std::shared_ptr<smtk::attribute::ItemDefinition> >& parent)
{
  py::class_<smtk::attribute::FileSystemItemDefinition, std::shared_ptr<smtk::attribute::FileSystemItemDefinition> > instance(m, "FileSystemItemDefinition", parent);
  instance
    .def_property("valueLabel", &smtk::attribute::FileSystemItemDefinition::valueLabel, &smtk::attribute::FileSystemItemDefinition::setValueLabel)
    .def_property("numberOfRequiredValues", &smtk::attribute::FileSystemItemDefinition::numberOfRequiredValues, &smtk::attribute::FileSystemItemDefinition::setNumberOfRequiredValues)
    .def_property("shouldBeRelative", &smtk::attribute::FileSystemItemDefinition::shouldBeRelative, &smtk::attribute::FileSystemItemDefinition::setShouldBeRelative)
    .def_property("maxNumberOfValues", &smtk::attribute::FileSystemItemDefinition::maxNumberOfValues, &smtk::attribute::FileSystemItemDefinition::setMaxNumberOfValues)
    .def_property("shouldExist", &smtk::attribute::FileSystemItemDefinition::shouldExist, &smtk::attribute::FileSystemItemDefinition::setShouldExist)
    .def_property("isExtensible", &smtk::attribute::FileSystemItemDefinition::isExtensible, &smtk::attribute::FileSystemItemDefinition::setIsExtensible)
    .def_property("defaultValue", &smtk::attribute::FileSystemItemDefinition::defaultValue, &smtk::attribute::FileSystemItemDefinition::setDefaultValue)
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::FileSystemItemDefinition::*)(::smtk::attribute::Attribute *, int) const) &smtk::attribute::FileSystemItemDefinition::buildItem)
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::FileSystemItemDefinition::*)(::smtk::attribute::Item *, int, int) const) &smtk::attribute::FileSystemItemDefinition::buildItem)
    .def("classname", &smtk::attribute::FileSystemItemDefinition::classname)
    .def("createCopy", &smtk::attribute::FileSystemItemDefinition::createCopy, py::arg("info"))
    .def("hasDefault", &smtk::attribute::FileSystemItemDefinition::hasDefault)
    .def("hasValueLabels", &smtk::attribute::FileSystemItemDefinition::hasValueLabels)
    .def("isValueValid", &smtk::attribute::FileSystemItemDefinition::isValueValid, py::arg("val"))
    .def("setCommonValueLabel", &smtk::attribute::FileSystemItemDefinition::setCommonValueLabel, py::arg("elabel"))
    .def("type", &smtk::attribute::FileSystemItemDefinition::type)
    .def("unsetDefaultValue", &smtk::attribute::FileSystemItemDefinition::unsetDefaultValue)
    .def("usingCommonLabel", &smtk::attribute::FileSystemItemDefinition::usingCommonLabel)
    .def_static("CastTo", [](const std::shared_ptr<smtk::attribute::ItemDefinition> i) {
        return std::dynamic_pointer_cast<smtk::attribute::FileSystemItemDefinition>(i);
      })
    ;
  return instance;
}

#endif
