//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_FileSystemItem_h
#define pybind_attribute_FileSystemItem_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/FileSystemItem.h"

namespace py = pybind11;

py::class_<smtk::attribute::FileSystemItem, std::shared_ptr<smtk::attribute::FileSystemItem> >
pybind11_init_smtk_attribute_FileSystemItem(py::module &m, py::class_<smtk::attribute::Item, std::shared_ptr<smtk::attribute::Item> >& parent)
{
  py::class_<smtk::attribute::FileSystemItem, std::shared_ptr<smtk::attribute::FileSystemItem> > instance(m, "FileSystemItem", parent);
  instance
    .def_property("numberOfValues", &smtk::attribute::FileSystemItem::numberOfValues, &smtk::attribute::FileSystemItem::setNumberOfValues)
    .def("appendValue", &smtk::attribute::FileSystemItem::appendValue, py::arg("val"))
    .def("assign", &smtk::attribute::FileSystemItem::assign, py::arg("sourceItem"), py::arg("options") = 0)
    .def("begin", &smtk::attribute::FileSystemItem::begin)
    .def("classname", &smtk::attribute::FileSystemItem::classname)
    .def("defaultValue", &smtk::attribute::FileSystemItem::defaultValue)
    .def("end", &smtk::attribute::FileSystemItem::end)
    .def("hasDefault", &smtk::attribute::FileSystemItem::hasDefault)
    .def("isExtensible", &smtk::attribute::FileSystemItem::isExtensible)
    .def("isSet", &smtk::attribute::FileSystemItem::isSet, py::arg("element") = 0)
    .def("isUsingDefault", (bool (smtk::attribute::FileSystemItem::*)(::size_t) const) &smtk::attribute::FileSystemItem::isUsingDefault)
    .def("isUsingDefault", (bool (smtk::attribute::FileSystemItem::*)() const) &smtk::attribute::FileSystemItem::isUsingDefault)
    .def("isValid", &smtk::attribute::FileSystemItem::isValid)
    .def("maxNumberOfValues", &smtk::attribute::FileSystemItem::maxNumberOfValues)
    .def("numberOfRequiredValues", &smtk::attribute::FileSystemItem::numberOfRequiredValues)
    .def("removeValue", &smtk::attribute::FileSystemItem::removeValue, py::arg("element"))
    .def("reset", &smtk::attribute::FileSystemItem::reset)
    .def("setToDefault", &smtk::attribute::FileSystemItem::setToDefault, py::arg("elementIndex") = 0)
    .def("setValue", (bool (smtk::attribute::FileSystemItem::*)(::std::string const &)) &smtk::attribute::FileSystemItem::setValue)
    .def("setValue", (bool (smtk::attribute::FileSystemItem::*)(::size_t, ::std::string const &)) &smtk::attribute::FileSystemItem::setValue)
    .def("shouldBeRelative", &smtk::attribute::FileSystemItem::shouldBeRelative)
    .def("shouldExist", &smtk::attribute::FileSystemItem::shouldExist)
    .def("type", &smtk::attribute::FileSystemItem::type)
    .def("unset", &smtk::attribute::FileSystemItem::unset, py::arg("element") = 0)
    .def("value", &smtk::attribute::FileSystemItem::value, py::arg("element") = 0)
    .def("valueAsString", (std::string (smtk::attribute::FileSystemItem::*)(::std::string const &) const) &smtk::attribute::FileSystemItem::valueAsString)
    .def("valueAsString", (std::string (smtk::attribute::FileSystemItem::*)(::size_t, ::std::string const &) const) &smtk::attribute::FileSystemItem::valueAsString)
    .def_static("CastTo", [](const std::shared_ptr<smtk::attribute::Item> i) {
        return std::dynamic_pointer_cast<smtk::attribute::FileSystemItem>(i);
      })
    ;
  return instance;
}

#endif
