//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_FileItemDefinition_h
#define pybind_attribute_FileItemDefinition_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/FileItemDefinition.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_FileItemDefinition(py::module &m, py::class_<smtk::attribute::FileSystemItemDefinition, std::shared_ptr<smtk::attribute::FileSystemItemDefinition> >& parent)
{
  py::class_<smtk::attribute::FileItemDefinition, std::shared_ptr<smtk::attribute::FileItemDefinition> > instance(m, "FileItemDefinition", parent);
  instance
    .def(py::init<::smtk::attribute::FileItemDefinition const &>())
    .def_static("New", &smtk::attribute::FileItemDefinition::New, py::arg("myName"))
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::FileItemDefinition::*)(::smtk::attribute::Attribute *, int) const) &smtk::attribute::FileItemDefinition::buildItem)
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::FileItemDefinition::*)(::smtk::attribute::Item *, int, int) const) &smtk::attribute::FileItemDefinition::buildItem)
    .def("classname", &smtk::attribute::FileItemDefinition::classname)
    .def("createCopy", &smtk::attribute::FileItemDefinition::createCopy, py::arg("info"))
    .def("getFileFilters", &smtk::attribute::FileItemDefinition::getFileFilters)
    .def("setFileFilters", &smtk::attribute::FileItemDefinition::setFileFilters, py::arg("filters"))
    .def("type", &smtk::attribute::FileItemDefinition::type)
    .def_static("CastTo", [](const std::shared_ptr<smtk::attribute::ItemDefinition> i) {
        return std::dynamic_pointer_cast<smtk::attribute::FileItemDefinition>(i);
      })
    ;
}

#endif
