//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_Definition_h
#define pybind_attribute_Definition_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/Definition.h"
#include "smtk/attribute/System.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_Definition(py::module &m)
{
  py::class_<smtk::attribute::Definition, std::shared_ptr<smtk::attribute::Definition> > instance(m, "Definition");
  instance
    .def_property("advanceLevel", &smtk::attribute::Definition::advanceLevel, &smtk::attribute::Definition::setAdvanceLevel)
    .def_property("rootName", &smtk::attribute::Definition::rootName, &smtk::attribute::Definition::setRootName)
    .def_property("version", &smtk::attribute::Definition::version, &smtk::attribute::Definition::setVersion)
    .def_property("label", &smtk::attribute::Definition::label, &smtk::attribute::Definition::setLabel)
    .def_property("detailedDescription", &smtk::attribute::Definition::detailedDescription, &smtk::attribute::Definition::setDetailedDescription)
    .def_property("isAbstract", &smtk::attribute::Definition::isAbstract, &smtk::attribute::Definition::setIsAbstract)
    .def_property("associationMask", &smtk::attribute::Definition::associationMask, &smtk::attribute::Definition::setAssociationMask)
    .def_property("briefDescription", &smtk::attribute::Definition::briefDescription, &smtk::attribute::Definition::setBriefDescription)
    .def_property("associationRule", &smtk::attribute::Definition::associationRule, &smtk::attribute::Definition::setAssociationRule)
    .def_property("isNodal", &smtk::attribute::Definition::isNodal, &smtk::attribute::Definition::setIsNodal)
    .def_property("isUnique", &smtk::attribute::Definition::isUnique, &smtk::attribute::Definition::setIsUnique)
    .def("classname", &smtk::attribute::Definition::classname)
    .def("type", &smtk::attribute::Definition::type)
    .def("system", &smtk::attribute::Definition::system)
    .def("baseDefinition", &smtk::attribute::Definition::baseDefinition)
    .def("isA", &smtk::attribute::Definition::isA, py::arg("def"))
    .def("numberOfCategories", &smtk::attribute::Definition::numberOfCategories)
    .def("isMemberOf", (bool (smtk::attribute::Definition::*)(::std::string const &) const) &smtk::attribute::Definition::isMemberOf)
    .def("isMemberOf", (bool (smtk::attribute::Definition::*)(::std::vector<std::basic_string<char>, std::allocator<std::basic_string<char> > > const &) const) &smtk::attribute::Definition::isMemberOf)
    .def("categories", &smtk::attribute::Definition::categories)
    .def("notApplicableColor", &smtk::attribute::Definition::notApplicableColor)
    .def("setNotApplicableColor", (void (smtk::attribute::Definition::*)(double, double, double, double)) &smtk::attribute::Definition::setNotApplicableColor)
    .def("setNotApplicableColor", (void (smtk::attribute::Definition::*)(double const *)) &smtk::attribute::Definition::setNotApplicableColor)
    .def("unsetNotApplicableColor", &smtk::attribute::Definition::unsetNotApplicableColor)
    .def("isNotApplicableColorSet", &smtk::attribute::Definition::isNotApplicableColorSet)
    .def("defaultColor", &smtk::attribute::Definition::defaultColor)
    .def("setDefaultColor", (void (smtk::attribute::Definition::*)(double, double, double, double)) &smtk::attribute::Definition::setDefaultColor)
    .def("setDefaultColor", (void (smtk::attribute::Definition::*)(double const *)) &smtk::attribute::Definition::setDefaultColor)
    .def("unsetDefaultColor", &smtk::attribute::Definition::unsetDefaultColor)
    .def("isDefaultColorSet", &smtk::attribute::Definition::isDefaultColorSet)
    .def("associatesWithVertex", &smtk::attribute::Definition::associatesWithVertex)
    .def("associatesWithEdge", &smtk::attribute::Definition::associatesWithEdge)
    .def("associatesWithFace", &smtk::attribute::Definition::associatesWithFace)
    .def("associatesWithVolume", &smtk::attribute::Definition::associatesWithVolume)
    .def("associatesWithModel", &smtk::attribute::Definition::associatesWithModel)
    .def("associatesWithGroup", &smtk::attribute::Definition::associatesWithGroup)
    .def("canBeAssociated", (bool (smtk::attribute::Definition::*)(::smtk::model::BitFlags) const) &smtk::attribute::Definition::canBeAssociated)
    .def("canBeAssociated", (bool (smtk::attribute::Definition::*)(::smtk::model::EntityRef, ::std::vector<smtk::attribute::Attribute *, std::allocator<smtk::attribute::Attribute *> > *) const) &smtk::attribute::Definition::canBeAssociated)
    .def("conflicts", &smtk::attribute::Definition::conflicts, py::arg("definition"))
    .def("numberOfItemDefinitions", &smtk::attribute::Definition::numberOfItemDefinitions)
    .def("itemDefinition", &smtk::attribute::Definition::itemDefinition, py::arg("ith"))
    .def("addItemDefinition", (bool (smtk::attribute::Definition::*)(::smtk::attribute::ItemDefinitionPtr)) &smtk::attribute::Definition::addItemDefinition, py::arg("cdef"))
    .def("findItemPosition", &smtk::attribute::Definition::findItemPosition, py::arg("name"))
    .def("buildAttribute", &smtk::attribute::Definition::buildAttribute, py::arg("attribute"))
    .def("resetItemOffset", &smtk::attribute::Definition::resetItemOffset)
    .def("itemOffset", &smtk::attribute::Definition::itemOffset)
    ;
}

#endif
