//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_DateTimeZonePair_h
#define pybind_attribute_DateTimeZonePair_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/DateTimeZonePair.h"

namespace py = pybind11;

PySharedPtrClass< smtk::attribute::DateTimeZonePair > pybind11_init_smtk_attribute_DateTimeZonePair(py::module &m)
{
  PySharedPtrClass< smtk::attribute::DateTimeZonePair > instance(m, "DateTimeZonePair");
  instance
    .def(py::init<>())
    .def(py::init<::smtk::attribute::DateTimeZonePair const &>())
    .def("__eq__", (bool (smtk::attribute::DateTimeZonePair::*)(::smtk::attribute::DateTimeZonePair const &) const) &smtk::attribute::DateTimeZonePair::operator==)
    .def("__lt__", (bool (smtk::attribute::DateTimeZonePair::*)(::smtk::attribute::DateTimeZonePair const &) const) &smtk::attribute::DateTimeZonePair::operator<)
    .def("__gt__", (bool (smtk::attribute::DateTimeZonePair::*)(::smtk::attribute::DateTimeZonePair const &) const) &smtk::attribute::DateTimeZonePair::operator>)
    .def("deepcopy", (smtk::attribute::DateTimeZonePair & (smtk::attribute::DateTimeZonePair::*)(::smtk::attribute::DateTimeZonePair const &)) &smtk::attribute::DateTimeZonePair::operator=)
    .def_property("dateTime", &smtk::attribute::DateTimeZonePair::dateTime, &smtk::attribute::DateTimeZonePair::setDateTime)
    .def_property("timeZone", &smtk::attribute::DateTimeZonePair::timeZone, &smtk::attribute::DateTimeZonePair::setTimeZone)
    //.def("dateTime", &smtk::attribute::DateTimeZonePair::dateTime)
    //.def("timeZone", &smtk::attribute::DateTimeZonePair::timeZone)
    .def("serialize", &smtk::attribute::DateTimeZonePair::serialize)
    .def("deserialize", &smtk::attribute::DateTimeZonePair::deserialize, py::arg("content"))
    ;
  return instance;
}

#endif
