//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_DateTimeItemDefinition_h
#define pybind_attribute_DateTimeItemDefinition_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/DateTimeItemDefinition.h"

namespace py = pybind11;

PySharedPtrClass< smtk::attribute::DateTimeItemDefinition > pybind11_init_smtk_attribute_DateTimeItemDefinition(py::module &m, PySharedPtrClass< smtk::attribute::ValueItemDefinitionTemplate<smtk::attribute::DateTimeZonePair> >& parent)
{
  PySharedPtrClass< smtk::attribute::DateTimeItemDefinition > instance(m, "DateTimeItemDefinition", parent);
  instance
    .def(py::init<::smtk::attribute::DateTimeItemDefinition const &>())
    .def_property("useTimeZone", &smtk::attribute::DateTimeItemDefinition::useTimeZone, &smtk::attribute::DateTimeItemDefinition::setUseTimeZone)
    .def_property("displayFormat", &smtk::attribute::DateTimeItemDefinition::displayFormat, &smtk::attribute::DateTimeItemDefinition::setDisplayFormat)
    .def_property("enableCalendarPopup", &smtk::attribute::DateTimeItemDefinition::useCalendarPopup, &smtk::attribute::DateTimeItemDefinition::setEnableCalendarPopup)
    .def_static("New", &smtk::attribute::DateTimeItemDefinition::New, py::arg("myName"))
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::DateTimeItemDefinition::*)(::smtk::attribute::Attribute *, int) const) &smtk::attribute::DateTimeItemDefinition::buildItem, py::arg("owningAttribute"), py::arg("itemPosition"))
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::DateTimeItemDefinition::*)(::smtk::attribute::Item *, int, int) const) &smtk::attribute::DateTimeItemDefinition::buildItem, py::arg("owningItem"), py::arg("position"), py::arg("subGroupPosition"))
    .def("classname", &smtk::attribute::DateTimeItemDefinition::classname)
    .def("createCopy", &smtk::attribute::DateTimeItemDefinition::createCopy, py::arg("info"))
    //.def("displayFormat", &smtk::attribute::DateTimeItemDefinition::displayFormat)
    //.def("setEnableCalendarPopup", &smtk::attribute::DateTimeItemDefinition::setEnableCalendarPopup, py::arg("mode"))
    .def("type", &smtk::attribute::DateTimeItemDefinition::type)
    //.def("useCalendarPopup", &smtk::attribute::DateTimeItemDefinition::useCalendarPopup)
    //.def("useTimeZone", &smtk::attribute::DateTimeItemDefinition::useTimeZone)
    ;
  return instance;
}

#endif
