//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_DateTimeItem_h
#define pybind_attribute_DateTimeItem_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/DateTimeItem.h"

namespace py = pybind11;

PySharedPtrClass< smtk::attribute::DateTimeItem > pybind11_init_smtk_attribute_DateTimeItem(py::module &m, PySharedPtrClass< smtk::attribute::ValueItemTemplate<smtk::attribute::DateTimeZonePair> >& parent)
{
  PySharedPtrClass< smtk::attribute::DateTimeItem > instance(m, "DateTimeItem", parent);
  instance
    .def(py::init<::smtk::attribute::DateTimeItem const &>())
    .def("assign", &smtk::attribute::DateTimeItem::assign, py::arg("sourceItem"), py::arg("options") = 0)
    .def("classname", &smtk::attribute::DateTimeItem::classname)
    .def("type", &smtk::attribute::DateTimeItem::type)
    ;
  return instance;
}

#endif
