//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_DateTime_h
#define pybind_attribute_DateTime_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/DateTime.h"
#include "smtk/attribute/TimeZone.h"

namespace py = pybind11;

PySharedPtrClass< smtk::attribute::DateTime > pybind11_init_smtk_attribute_DateTime(py::module &m)
{
  PySharedPtrClass< smtk::attribute::DateTime > instance(m, "DateTime");
  instance
    .def(py::init<>())
    .def(py::init<::smtk::attribute::DateTime const &>())
    .def("__eq__", (bool (smtk::attribute::DateTime::*)(::smtk::attribute::DateTime const &) const) &smtk::attribute::DateTime::operator==)
    .def("__lt__", (bool (smtk::attribute::DateTime::*)(::smtk::attribute::DateTime const &) const) &smtk::attribute::DateTime::operator<)
    .def("__gt__", (bool (smtk::attribute::DateTime::*)(::smtk::attribute::DateTime const &) const) &smtk::attribute::DateTime::operator>)
    .def("deepcopy", (smtk::attribute::DateTime & (smtk::attribute::DateTime::*)(::smtk::attribute::DateTime const &)) &smtk::attribute::DateTime::operator=)
    .def("setComponents", &smtk::attribute::DateTime::setComponents, py::arg("year"), py::arg("month"), py::arg("day"), py::arg("hour"), py::arg("minute"), py::arg("second"), py::arg("millisecond"), py::arg("timezone")=nullptr)
    //.def("components", &smtk::attribute::DateTime::components)
    .def("isSet", &smtk::attribute::DateTime::isSet)
    .def("deserialize", &smtk::attribute::DateTime::deserialize, py::arg("ts"))
    .def("serialize", &smtk::attribute::DateTime::serialize)

    // Modified methods
    .def("components",
         [](const smtk::attribute::DateTime &dt) {
         int yr=-1, month=-1, day=-1, hour=-1, minute=-1, sec=-1, msec=-1;
         dt.components(yr, month, day, hour, minute, sec, msec);
         return std::make_tuple(yr, month, day, hour, minute, sec, msec);
         })
    .def("components",
         [](const smtk::attribute::DateTime &dt, smtk::attribute::TimeZone tz) {
         int yr=-1, month=-1, day=-1, hour=-1, minute=-1, sec=-1, msec=-1;
         dt.components(yr, month, day, hour, minute, sec, msec, &tz);
         return std::make_tuple(yr, month, day, hour, minute, sec, msec);
         })
    ;
  return instance;
}

#endif
