//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#include <pybind11/pybind11.h>

namespace py = pybind11;

template <typename T, typename... Args>
using PySharedPtrClass = py::class_<T, std::shared_ptr<T>, Args...>;

#include "PybindAttribute.h"
#include "PybindDefinition.h"
#include "PybindDateTime.h"
#include "PybindDateTimeItem.h"
#include "PybindDateTimeItemDefinition.h"
#include "PybindDateTimeZonePair.h"
#include "PybindDirectoryItem.h"
#include "PybindDirectoryItemDefinition.h"
#include "PybindDoubleItem.h"
#include "PybindDoubleItemDefinition.h"
#include "PybindFileItem.h"
#include "PybindFileItemDefinition.h"
#include "PybindFileSystemItem.h"
#include "PybindFileSystemItemDefinition.h"
#include "PybindGroupItem.h"
#include "PybindGroupItemDefinition.h"
#include "PybindIntItem.h"
#include "PybindIntItemDefinition.h"
#include "PybindItem.h"
#include "PybindItemDefinition.h"
#include "PybindMeshItem.h"
#include "PybindMeshItemDefinition.h"
#include "PybindMeshSelectionItem.h"
#include "PybindMeshSelectionItemDefinition.h"
#include "PybindModelEntityItem.h"
#include "PybindModelEntityItemDefinition.h"
#include "PybindRefItem.h"
#include "PybindRefItemDefinition.h"
#include "PybindSearchStyle.h"
#include "PybindStringItem.h"
#include "PybindStringItemDefinition.h"
#include "PybindSystem.h"
#include "PybindTimeZone.h"
#include "PybindValueItem.h"
#include "PybindValueItemDefinition.h"
#include "PybindValueItemDefinitionTemplate.h"
#include "PybindValueItemTemplate.h"
#include "PybindVoidItem.h"
#include "PybindVoidItemDefinition.h"

PYBIND11_DECLARE_HOLDER_TYPE(T, std::shared_ptr<T>);

PYBIND11_PLUGIN(smtkPybindAttribute)
{
  py::module attribute("smtkPybindAttribute", "<description>");

  // The order of these function calls is important! It was determined by
  // comparing the dependencies of each of the wrapped objects.
  pybind11_init_smtk_attribute_SearchStyle(attribute);
  pybind11_init_smtk_attribute_MeshModifyMode(attribute);
  pybind11_init_smtk_attribute_DateTime(attribute);
  pybind11_init_smtk_attribute_TimeZone(attribute);
  pybind11_init_smtk_attribute_DateTimeZonePair(attribute);

  PySharedPtrClass<smtk::attribute::Item> item =
    pybind11_init_smtk_attribute_Item(attribute);
  PySharedPtrClass<smtk::attribute::ValueItem> valueItem =
    pybind11_init_smtk_attribute_ValueItem(attribute, item);
  PySharedPtrClass<smtk::attribute::ValueItemTemplate<int> > valueItemTemplate_int_ =
    pybind11_init_smtk_attribute_ValueItemTemplate_int_(attribute, valueItem);
  PySharedPtrClass<smtk::attribute::ValueItemTemplate<double> > valueItemTemplate_double_ =
    pybind11_init_smtk_attribute_ValueItemTemplate_double_(attribute, valueItem);
  PySharedPtrClass<smtk::attribute::ValueItemTemplate<std::string> > valueItemTemplate_string_ =
    pybind11_init_smtk_attribute_ValueItemTemplate_string_(attribute, valueItem);
  PySharedPtrClass<smtk::attribute::ValueItemTemplate<smtk::attribute::DateTimeZonePair> > valueItemTemplate_DateTimeZonePair_ =
    pybind11_init_smtk_attribute_ValueItemTemplate_DateTimeZonePair_(attribute, valueItem);
  pybind11_init_smtk_attribute_IntItem(attribute, valueItemTemplate_int_);
  pybind11_init_smtk_attribute_DoubleItem(attribute, valueItemTemplate_double_);
  pybind11_init_smtk_attribute_StringItem(attribute, valueItemTemplate_string_);
  pybind11_init_smtk_attribute_DateTimeItem(attribute, valueItemTemplate_DateTimeZonePair_);

  pybind11_init_smtk_attribute_VoidItem(attribute, item);
  pybind11_init_smtk_attribute_RefItem(attribute, item);
  PySharedPtrClass<smtk::attribute::FileSystemItem> fileSystemItem =
    pybind11_init_smtk_attribute_FileSystemItem(attribute, item);
  pybind11_init_smtk_attribute_FileItem(attribute, fileSystemItem);
  pybind11_init_smtk_attribute_DirectoryItem(attribute, fileSystemItem);
  pybind11_init_smtk_attribute_GroupItem(attribute, item);
  pybind11_init_smtk_attribute_ModelEntityItem(attribute, item);
  pybind11_init_smtk_attribute_MeshItem(attribute, item);
  pybind11_init_smtk_attribute_MeshSelectionItem(attribute, item);

  pybind11_init_smtk_attribute_System(attribute);
  pybind11_init_smtk_attribute_Attribute(attribute);

  pybind11_init_smtk_attribute_Definition(attribute);
  PySharedPtrClass<smtk::attribute::ItemDefinition> itemDefinition =
    pybind11_init_smtk_attribute_ItemDefinition(attribute);
  PySharedPtrClass<smtk::attribute::ValueItemDefinition> valueItemDefinition =
    pybind11_init_smtk_attribute_ValueItemDefinition(attribute, itemDefinition);
  PySharedPtrClass<smtk::attribute::ValueItemDefinitionTemplate<int> > valueItemDefinitionTemplate_int_ =
    pybind11_init_smtk_attribute_ValueItemDefinitionTemplate_int_(attribute, valueItemDefinition);
  PySharedPtrClass<smtk::attribute::ValueItemDefinitionTemplate<double> > valueItemDefinitionTemplate_double_ =
    pybind11_init_smtk_attribute_ValueItemDefinitionTemplate_double_(attribute, valueItemDefinition);
  PySharedPtrClass<smtk::attribute::ValueItemDefinitionTemplate<std::string> > valueItemDefinitionTemplate_string_ =
    pybind11_init_smtk_attribute_ValueItemDefinitionTemplate_string_(attribute, valueItemDefinition);
  PySharedPtrClass<smtk::attribute::ValueItemDefinitionTemplate<smtk::attribute::DateTimeZonePair> > valueItemDefinitionTemplate_DateTimeZonePair_ =
    pybind11_init_smtk_attribute_ValueItemDefinitionTemplate_DateTimeZonePair_(attribute, valueItemDefinition);
  pybind11_init_smtk_attribute_IntItemDefinition(attribute, valueItemDefinitionTemplate_int_);
  pybind11_init_smtk_attribute_DoubleItemDefinition(attribute, valueItemDefinitionTemplate_double_);
  pybind11_init_smtk_attribute_StringItemDefinition(attribute, valueItemDefinitionTemplate_string_);
  pybind11_init_smtk_attribute_DateTimeItemDefinition(attribute, valueItemDefinitionTemplate_DateTimeZonePair_);

  pybind11_init_smtk_attribute_VoidItemDefinition(attribute, itemDefinition);
  pybind11_init_smtk_attribute_RefItemDefinition(attribute, itemDefinition);
  PySharedPtrClass<smtk::attribute::FileSystemItemDefinition> fileSystemItemDefinition =
    pybind11_init_smtk_attribute_FileSystemItemDefinition(attribute, itemDefinition);
  pybind11_init_smtk_attribute_FileItemDefinition(attribute, fileSystemItemDefinition);
  pybind11_init_smtk_attribute_DirectoryItemDefinition(attribute, fileSystemItemDefinition);
  pybind11_init_smtk_attribute_GroupItemDefinition(attribute, itemDefinition);
  pybind11_init_smtk_attribute_ModelEntityItemDefinition(attribute, itemDefinition);
  pybind11_init_smtk_attribute_MeshItemDefinition(attribute, itemDefinition);
  pybind11_init_smtk_attribute_MeshSelectionItemDefinition(attribute, itemDefinition);

  return attribute.ptr();
}
