<?xml version="1.0"?>
<SMTK_AttributeSystem Version="2">
  <!--**********  Category and Analysis Information ***********-->
  <Categories Default="General">
    <Cat>Omega3P</Cat>
    <Cat>S3P</Cat>
    <Cat>T3P</Cat>
    <Cat>Track3P</Cat>
  </Categories>
  <Analyses>
    <Analysis Type="Omega3P Analysis">
      <Cat>Omega3P</Cat>
    </Analysis>
    <Analysis Type="S3P Analysis">
      <Cat>S3P</Cat>
    </Analysis>
    <Analysis Type="T3P Analysis">
      <Cat>T3P</Cat>
    </Analysis>
    <Analysis Type="Track3P Analysis">
      <Cat>Track3P</Cat>
    </Analysis>
  </Analyses>

  <!--**********  Include files ***********-->
  <!-- One include file with definitions per tab -->
  <!-- Must load boundaryconditions before analysis, for AttributeRef -->
  <Includes>
    <File>templates/beamloading.sbt</File>
    <File>templates/boundarycondition.sbt</File>
    <File>templates/loading.sbt</File>
    <File>templates/material.sbt</File>
    <File>templates/monitor.sbt</File>
    <File>templates/analysis.sbt</File>
    <File>templates/track3p.sbt</File>
  </Includes>

  <!--********** Workflow Views ***********-->
  <Views>
    <View Type="Group" Title="SimBuilder" TopLevel="true" TabPosition="North"
          FilterByAdvanceLevel="false">
      <DefaultColor>1., 1., 0.5, 1.</DefaultColor>
      <InvalidColor>1, 0.5, 0.5, 1</InvalidColor>
      <AdvancedFontEffects />
      <Views>
        <View Title="Boundary Conditions" />
        <View Title="Materials" />
        <View Title="Analysis" />
        <View Title="Beam Info" />
        <View Title="Loading" />
        <View Title="Monitors" />
        <View Title="Track3P" />
      </Views>
    </View>

    <View Type="Group" Title="Boundary Conditions" Style="Tiled">
      <Views>
        <View Title="HFormulation" />
        <View Title="Surface Properties" />
      </Views>
    </View>
    <View Type="Instanced" Title="HFormulation">
      <InstancedAttributes>
        <Att Name="HForumulation" Type="HFormulation" />
      </InstancedAttributes>
    </View>
    <View Type="Attribute" Title="Surface Properties" ModelEntityFilter="f">
      <AttributeTypes>
        <Att Type="SurfaceProperty" />
      </AttributeTypes>
    </View>
    <View Type="Attribute" Title="Monitors">
      <AttributeTypes>
        <Att Type="Monitor" />
      </AttributeTypes>
    </View>

    <View Type="Attribute" Title="Materials" ModelEntityFilter="r">
      <AttributeTypes>
        <Att Type="Material" />
      </AttributeTypes>
    </View>
    <View Type="Attribute" Title="Beam Info">
      <AttributeTypes>
        <Att Type="BeamLoading" />
      </AttributeTypes>
    </View>
    <View Type="Attribute" Title="Loading">
      <AttributeTypes>
        <Att Type="Loading" />
      </AttributeTypes>
    </View>
    <View Type="Group" Title="Analysis" Style="Tiled">
      <Views>
        <View Title="Tolerant" />
        <View Title="Finite Element" />
        <View Title="Moving Window" />
        <View Title="Frequency Information" />
        <View Title="Post Process" />
        <View Title="High Order Regions" />
      </Views>
    </View>
    <View Type="Instanced" Title="Tolerant">
      <InstancedAttributes>
        <Att Name="Tolerant" Type="Tolerant" />
      </InstancedAttributes>
    </View>
    <View Type="Instanced" Title="Finite Element">
      <InstancedAttributes>
        <Att Name="Finite Element Info" Type="FEInfo" />
      </InstancedAttributes>
    </View>
    <View Type="Instanced" Title="Moving Window">
      <InstancedAttributes>
        <Att Name="MovingWindow" Type="MovingWindow" />
      </InstancedAttributes>
    </View>
    <View Type="Instanced" Title="Frequency Information">
      <InstancedAttributes>
        <Att Name="EigenSolver" Type="FrequencyInfo" />
      </InstancedAttributes>
    </View>
    <View Type="Instanced" Title="Post Process">
      <InstancedAttributes>
        <Att Name="PostProcess" Type="PostProcess" />
      </InstancedAttributes>
    </View>
    <View Type="Attribute" Title="High Order Regions" ModelEntityFilter="r">
      <AttributeTypes>
        <Att Type="RegionHighOrder" />
      </AttributeTypes>
    </View>
  </Views>
</SMTK_AttributeSystem>
