<?xml version="1.0" encoding="utf-8" ?>
<SMTK_AttributeSystem Version="2">

  <!-- Category & Analysis specifications -->
  <Categories Default="Heat Transfer">
    <Cat>Enclosure Radiation</Cat>
    <Cat>Fluid Flow</Cat>
    <Cat>Heat Transfer</Cat>
    <Cat>Induction Heating</Cat>
    <Cat>Solid Mechanics</Cat>
  </Categories>

  <Analyses>
    <Analysis Type="Heat Transfer">
      <Cat>Heat Transfer</Cat>
    </Analysis>
    <Analysis Type="Enclosure Radiation" BaseType="Heat Transfer">
      <Cat>Enclosure Radiation</Cat>
    </Analysis>
    <Analysis Type="Induction Heating" BaseType="Heat Transfer">
      <Cat>Induction Heating</Cat>
    </Analysis>
    <Analysis Type="Fluid Flow">
      <Cat>Fluid Flow</Cat>
    </Analysis>
    <Analysis Type="Solid Mechanics">
      <Cat>Solid Mechanics</Cat>
    </Analysis>
  </Analyses>

  <!-- Attribute definitions -->
  <Includes>
    <!-- Note: order is important, e.g., put expressions first -->
    <File>internal/templates/tabular-function.sbt</File>
    <File>internal/templates/material.sbt</File>
    <File>internal/templates/thermal-surface-condition.sbt</File>
    <File>internal/templates/boundary-condition.sbt</File>
    <File>internal/templates/fluid-numerics.sbt</File>
    <File>internal/templates/numerics-solver.sbt</File>
    <File>internal/templates/body-source-probe.sbt</File>
    <File>internal/templates/enclosure.sbt</File>
    <File>internal/templates/other.sbt</File>
    <File>internal/templates/initial-conditions.sbt</File>

    <File>internal/templates/views/fluid-flow-views.sbt</File>
    <File>internal/templates/views/heat-transfer-views.sbt</File>
  </Includes>

  <Definitions>
    <!-- For enabling simulation modules -->
    <AttDef Type="analysis">
      <ItemDefinitions>
        <Group Name="Heat Transfer" Optional="true" IsEnabledByDefault="false">
          <ItemDefinitions>
            <Void Name="Enclosure Radiation" Optional="true" IsEnabledByDefault="false">
              <Categories>
                <Cat>Enclosure Radiation</Cat>
                <Cat>Fluid Flow</Cat>
                <Cat>Heat Transfer</Cat>
                <Cat>Induction Heating</Cat>
                <Cat>Solid Mechanics</Cat>
              </Categories>
            </Void>
            <Void Name="Induction Heating" Optional="true" IsEnabledByDefault="false">
              <Categories>
                <Cat>Enclosure Radiation</Cat>
                <Cat>Fluid Flow</Cat>
                <Cat>Heat Transfer</Cat>
                <Cat>Induction Heating</Cat>
                <Cat>Solid Mechanics</Cat>
              </Categories>
            </Void>
          </ItemDefinitions>
        </Group>
        <Void Name="Fluid Flow" Optional="true" IsEnabledByDefault="false">
          <Categories>
            <Cat>Enclosure Radiation</Cat>
            <Cat>Fluid Flow</Cat>
            <Cat>Heat Transfer</Cat>
            <Cat>Induction Heating</Cat>
            <Cat>Solid Mechanics</Cat>
          </Categories>
        </Void>
        <Void Name="Solid Mechanics" Optional="true" IsEnabledByDefault="false">
          <Categories>
            <Cat>Enclosure Radiation</Cat>
            <Cat>Fluid Flow</Cat>
            <Cat>Heat Transfer</Cat>
            <Cat>Induction Heating</Cat>
            <Cat>Solid Mechanics</Cat>
          </Categories>
        </Void>
      </ItemDefinitions>
    </AttDef>
    <AttDef Type="export">
    </AttDef>

    <!-- Selector attribute - used by selector view-->
<!--     <AttDef Type="ModuleSelectorAtt" Version="0">
      <ItemDefinitions>
        <String Name="ModuleSelectorItem" Label="Select Module:">
          <DiscreteInfo DefaultIndex="1">
            <Value Enum="Fluid Flow">Fluid Flow</Value>
            <Value Enum="Heat Transfer">Heat Transfer</Value>
            <Value Enum="Enclosure Radiation">Enclosure Radiation</Value>
            <Value Enum="Induction Heating">Induction Heating</Value>
            <Value Enum="Solid Mechanics">Solid Mechanics</Value>
          </DiscreteInfo>
        </String>
      </ItemDefinitions>
    </AttDef> -->

  </Definitions>

  <!-- View specifications -->
  <Views>
    <View Type="Group" Title="TopLevel" TopLevel="true" TabPosition="North"
      FilterByAdvanceLevel="true" FilterByCategory="false">
      <Views>
        <View Title="Analysis" />
        <View Title="Materials" />
        <View Title="Modules" />
        <View Title="Body" />
        <View Title="Globals" />
        <View Title="Other" />
      </Views>
    </View>

    <!-- Placeholder for "analysis view" Todo -->
    <View Type="Analysis" Title="Analysis" AnalysisAttributeName="truchasAnalysis" AnalysisAttributeType="truchasAnalysisDefinition">
    </View>

    <View Type="Instanced" Name="SelectModules" Label="Select Modules">
      <InstancedAttributes>
        <Att Name="analysis-att" Type="analysis"></Att>
      </InstancedAttributes>
    </View>

    <View Type="Group" Name="Modules" Label="Modules" TabPosition="North">
      <Views>
        <View Title="Enclosure Radiation" />
        <View Title="Fluid Flow" />         <!-- In views/fluid-flow-views.sbt -->
        <View Title="Heat Transfer" />      <!-- In views/heat-transfer-views.sbt -->
        <View Title="Induction Heating" />
        <View Title="Solid Mechanics" />
      </Views>
    </View>

    <View Type="Instanced" Name="Enclosure Radiation">
      <InstancedAttributes>
        <Att Name="enclosure-radiation" Type="enclosure-radiation" />
      </InstancedAttributes>
    </View>

    <View Type="Instanced" Name="Induction Heating">
      <InstancedAttributes>
      </InstancedAttributes>
    </View>

    <View Type="Instanced" Name="Solid Mechanics">
      <InstancedAttributes>
      </InstancedAttributes>
    </View>


    <View Type="Group" Title="Materials" TabPosition="North">
      <Views>
        <!--View Title="Background Material" /-->
        <View Title="Material" />
        <View Title="Material Assignment" />
      </Views>
    </View>
<!--     <View Type="Instanced" Title="Background Material">
      <InstancedAttributes>
        <Att Name="Background Material" Type="background-material" />
      </InstancedAttributes>
    </View> -->
    <View Type="Attribute" Title="Material" Label="Specification" HideAssociations="true">
      <AttributeTypes>
        <Att Type="material"/>
      </AttributeTypes>
    </View>
    <View Type="Associations" Title="Material Assignment" Label="Assignment">
      <AttributeTypes>
        <Att Type="material"/>
      </AttributeTypes>
    </View>

    <View Type="Group" Title="Body" Label="Initial Conditions" TabPosition="North">
      <Views>
        <View Title="Temperature IC" />
        <View Title="Velocity IC" />
      </Views>
    </View>

    <View Type="Attribute" Name="Temperature IC" Label="Temperature">
      <AttributeTypes>
        <Att Type="TemperatureInitialCondition" />
      </AttributeTypes>
    </View>

    <View Type="Attribute" Name="Velocity IC" Label="Velocity">
      <AttributeTypes>
        <Att Type="VelocityInitialCondition" />
      </AttributeTypes>
    </View>

     <View Type="Group" Title="Other" Style="tiled">
      <Views>
        <View Title="Other Instanced" />
        <View Title="Probes" />
      </Views>
    </View>
    <View Type="Instanced" Title="Other Instanced" Label="Mesh">
      <InstancedAttributes>
        <Att Name="Mesh" Type="mesh" />
      </InstancedAttributes>
    </View>
    <View Type="Attribute" Title="Probes">
      <AttributeTypes>
        <Att Type="probe" />
      </AttributeTypes>
    </View>
    <View Type="SimpleExpression" Title="Functions">
      <Att Type="tabular-function"/>
    </View>

    <View Type="Instanced" Title="General">
      <InstancedAttributes>
        <Att Name="numerics-att" Type="numerics" />
        <Att Name="outputs-att" Type="outputs" />
        <Att Name="simulation-control-att" Type="simulation-control" />
<!--         <Att Name="Mesh" Type="mesh" /> -->
      </InstancedAttributes>
    </View>

    <View Type="Group" Title="Globals" Style="Tiled">
      <Views>
        <View Title="Global Constants" />
        <View Title="Functions" />
      </Views>
    </View>

    <View Type="Instanced" Title="Global Constants">
      <InstancedAttributes>
        <Att Name="physics" Type="physics" />
        <Att Name="physical-constants" Type="physical-constants" />
      </InstancedAttributes>
    </View>

  </Views>

</SMTK_AttributeSystem>
