#[==[.md
# Testing packages

The packages created by the superbuild packaging support may also be tested. In
order to do so, the created package must first be extracted.
#]==]

set(_superbuild_testing_cmake_dir "${CMAKE_CURRENT_LIST_DIR}")

#[==[.md
The `superbuild_add_extract_test` extracts a package generated by a packaging
test.

```
superbuild_add_extract_test(<NAME> <PREFIX> <GENERATOR> <OUTPUT>
  [<PROPERTY> <VALUE>]...)
```

The `NAME` and `GENERATOR` arguments must match the corresponding package test
that should be extracted. There is also the `PREFIX` argument which should be a
prefix long enough to make the glob for the resulting package name unique.

The `OUTPUT` is the path to the directory that the package should be extracted
into. One intermediate directory is removed from the extraction. For example, a
package containing `dirname/bin/program` and `dirname/include/header.h` will
have a `bin` and `include` directory under the given output directory.
#]==]

# TODO: use a PROPERTIES argument
function (superbuild_add_extract_test name glob_prefix generator output)
  set(_ZIP_test_glob "${glob_prefix}*.zip")
  set(_NSIS_test_glob "${glob_prefix}*.exe")
  set(_DragNDrop_test_glob "${glob_prefix}*.dmg")
  set(_TGZ_test_glob "${glob_prefix}*.tar.gz")

  if (NOT DEFINED _${generator}_test_glob)
    message(FATAL_ERROR
      "No known glob to find packages created by the ${generator} CPack "
      "generator.")
  endif ()

  add_test(
    NAME    "extract-${name}-${generator}"
    COMMAND "${CMAKE_COMMAND}"
            "-Dname:STRING=${name}"
            "-Dtest_dir:PATH=${CMAKE_BINARY_DIR}"
            "-Dbinary_glob:STRING=${_${generator}_test_glob}"
            "-Doutput_dir:PATH=${output}"
            -P "${_superbuild_testing_cmake_dir}/scripts/extract_test.cmake")
  set_tests_properties("extract-${name}-${generator}"
    PROPERTIES
      DEPENDS "cpack-${name}-${generator}"
      ${ARGN})
endfunction ()

# TODO: Add support for extracting a specific CPack's output.
