superbuild_add_project(python3
  CAN_USE_SYSTEM
  BUILD_IN_SOURCE 1
  CONFIGURE_COMMAND ""
  BUILD_COMMAND ""
  INSTALL_COMMAND
    "${CMAKE_COMMAND}"
      "-Dinstall_location:PATH=<INSTALL_DIR>/Python"
      -P "${CMAKE_CURRENT_LIST_DIR}/scripts/python3.install.cmake")

cmake_dependent_option(PACKAGE_SYSTEM_python3 "Copy system python into cmb packages" ON
  "USE_SYSTEM_python3" OFF)

if (python3_enabled AND PACKAGE_SYSTEM_python3)
  set(superbuild_python_executable "${PYTHON_EXECUTABLE}"
    CACHE INTERNAL "")
  get_filename_component(system_python_location "$PYTHON_EXECUTABLE" DIRECTORY)
  set(superbuild_python_pip "${system_python_location}/Scripts/pip.exe"
    CACHE INTERNAL "")
  superbuild_add_extra_cmake_args(
    -DPython3_EXECUTABLE:FILEPATH="${system_python_location}/python.exe"
    -DPython3_INCLUDE_DIR:PATH="${system_python_location}/include/"
    -DPython3_LIBRARY:FILEPATH="${system_python_location}/libs/python37.lib"
    -DPython3_LIBRARY_RELEASE:FILEPATH="${system_python_location}/libs/python37.lib"
    -DPython3_FIND_REGISTRY:STRING=NEVER

    -DPYTHON_EXECUTABLE:FILEPATH="${system_python_location}/python.exe"
    -DPYTHON_INCLUDE_DIR:PATH="${system_python_location}/include/"
    -DPYTHON_LIBRARY:FILEPATH="${system_python_location}/python37.lib"
    -DPYTHON_LIBRARY_RELEASE:FILEPATH="${system_python_location}/libs/python37.lib"
    -DPYTHON_FIND_REGISTRY:STRING=NEVER
  )

elseif (python3_enabled)
  set(superbuild_python_executable "${superbuild_install_location}/Python/python.exe"
    CACHE INTERNAL "")
  set(superbuild_python_pip "${superbuild_install_location}/Python/Scripts/pip.exe"
    CACHE INTERNAL "")
  superbuild_add_extra_cmake_args(
    -DPython3_EXECUTABLE:FILEPATH=<INSTALL_DIR>/Python/python.exe
    -DPython3_INCLUDE_DIR:PATH=<INSTALL_DIR>/Python/include/
    -DPython3_LIBRARY:FILEPATH=<INSTALL_DIR>/Python/libs/python37.lib
    -DPython3_LIBRARY_RELEASE:FILEPATH=<INSTALL_DIR>/Python/libs/python37.lib
    -DPython3_FIND_REGISTRY:STRING=NEVER

    -DPYTHON_EXECUTABLE:FILEPATH=<INSTALL_DIR>/Python/python.exe
    -DPYTHON_INCLUDE_DIR:PATH=<INSTALL_DIR>/Python/include/
    -DPYTHON_LIBRARY:FILEPATH=<INSTALL_DIR>/Python/libs/python37.lib
    -DPYTHON_LIBRARY_RELEASE:FILEPATH=<INSTALL_DIR>/Python/libs/python37.lib
    -DPYTHON_FIND_REGISTRY:STRING=NEVER
  )
else ()
  set(superbuild_python_executable ""
    CACHE INTERNAL "")
  set(superbuild_python_pip ""
    CACHE INTERNAL "")
endif ()

set(superbuild_python_version "3.7"
  CACHE INTERNAL "")
