get_property(choco_install GLOBAL PROPERTY choco_install_python)
if (choco_install)
  get_property(python_version GLOBAL PROPERTY choco_python_version)
  # Support windows format (backslash)
  set(cmake_install_dir "${superbuild_install_location}/Python")
  string(REGEX REPLACE "/" "\\\\\\\\" native_install_dir "${cmake_install_dir}")
  superbuild_add_project(python3
    DOWNLOAD_COMMAND ""
    CONFIGURE_COMMAND ""
    BUILD_COMMAND ""
    INSTALL_COMMAND
      choco install python3
      --version ${python_version}
      --installargs "'/quiet TargetDir=\\\"${native_install_dir}\\\" Shortcuts=0 Include_doc=0 Include_tcltk=0 Include_launcher=0'"
      --overrideargs --yes)
else()
  superbuild_add_project(python3
    CAN_USE_SYSTEM
    BUILD_IN_SOURCE 1
    CONFIGURE_COMMAND ""
    BUILD_COMMAND ""
    INSTALL_COMMAND
      "${CMAKE_COMMAND}"
        "-Dinstall_location:PATH=<INSTALL_DIR>/Python"
        -P "${CMAKE_CURRENT_LIST_DIR}/scripts/python3.install.cmake")
endif()

if (python3_enabled)
  set(superbuild_python_executable "${superbuild_install_location}/Python/python.exe"
    CACHE INTERNAL "")
  set(superbuild_python_pip "${superbuild_install_location}/Python/Scripts/pip.exe"
    CACHE INTERNAL "")
else ()
  set(superbuild_python_executable ""
    CACHE INTERNAL "")
  set(superbuild_python_pip ""
    CACHE INTERNAL "")
endif ()

set(superbuild_python_version "3.7"
  CACHE INTERNAL "")

superbuild_add_extra_cmake_args(
  -DPython3_EXECUTABLE:FILEPATH=<INSTALL_DIR>/Python/python.exe
  -DPython3_INCLUDE_DIR:PATH=<INSTALL_DIR>/Python/include/
  -DPython3_LIBRARY:FILEPATH=<INSTALL_DIR>/Python/libs/python37.lib
  -DPython3_LIBRARY_RELEASE:FILEPATH=<INSTALL_DIR>/Python/libs/python37.lib
  -DPython3_FIND_REGISTRY:STRING=NEVER

  -DPYTHON_EXECUTABLE:FILEPATH=<INSTALL_DIR>/Python/python.exe
  -DPYTHON_INCLUDE_DIR:PATH=<INSTALL_DIR>/Python/include/
  -DPYTHON_LIBRARY:FILEPATH=<INSTALL_DIR>/Python/libs/python37.lib
  -DPYTHON_LIBRARY_RELEASE:FILEPATH=<INSTALL_DIR>/Python/libs/python37.lib
  -DPYTHON_FIND_REGISTRY:STRING=NEVER
)
