add_external_project(szip
  CMAKE_ARGS
    -DBUILD_SHARED_LIBS:BOOL=ON
    -DBUILD_TESTING:BOOL=OFF
  PATCH_COMMAND
    # BUG: szip does not install ricehdf.h
    # replace the file with an appropriate version.
    ${CMAKE_COMMAND} -E copy_if_different ${SuperBuild_PROJECTS_DIR}/patches/szip.src.CMakeLists.txt
                                          <SOURCE_DIR>/src/CMakeLists.txt
)

# This patch fixes the unnecessary installation rule for the cgns.dll which was incorrect
# anyways when using MSVC (since the path didn't consider build configuration).
add_external_project_step(szip-fix-szip-config
  COMMENT "Fixing Windows install rules for CGNS tools"
  COMMAND ${CMAKE_COMMAND} -E copy_if_different
    ${SuperBuild_PROJECTS_DIR}/patches/szip.config.cmake.SZIP-config.cmake.install.in
    <SOURCE_DIR>/config/cmake/SZIP-config.cmake.install.in
  DEPENDEES update
  DEPENDERS patch)

# any project depending on szip, inherits these cmake variables
add_extra_cmake_args(
    -DSZIP_LIBRARY:FILEPATH=<INSTALL_DIR>/lib/szip.lib
    -DSZIP_INCLUDE_DIR:FILEPATH=<INSTALL_DIR>/include)
