set(CPACK_MONOLITHIC_INSTALL TRUE)

# URL to website providing assistance in installing your application.
set (CPACK_NSIS_HELP_LINK "http://paraview.org/Wiki/ParaView")
set (CPACK_NSIS_MENU_LINKS
  "bin/ModelBuilder.exe" "Model Builder"
  "bin/paraview.exe" "ParaView"
  "bin/pvserver.exe" "pvserver (Server)"
  "bin/pvdataserver.exe" "pvdataserver (Data-Server)"
  "bin/pvrenderserver.exe" "pvrenderserver (Render-Server)")
if (python_ENABLED)
  set (CPACK_NSIS_MENU_LINKS ${CPACK_NSIS_MENU_LINKS}
    "bin/pvpython.exe" "pvpython (Python Shell)")
endif()

#FIXME: need a pretty icon.
#set (CPACK_NSIS_MUI_ICON "${CMAKE_CURRENT_LIST_DIR}/paraview.ico")

#------------------------------------------------------------------------------

# install executables to bin. Don't use file glob since that will
# parsed at configure time, and no executables will be installed. Instead use
# install(Directory ) so that it is parsed at install time.
install(DIRECTORY "${install_location}/bin/"
        DESTINATION "bin"
        USE_SOURCE_PERMISSIONS
        COMPONENT superbuild
        REGEX "CMB.*"
        PATTERN "ModelBuilder"
        PATTERN "mesh"
        PATTERN "model"
        PATTERN "shiboken")

# install all dlls to bin. This will install all VTK/ParaView dlls plus any
# other tool dlls that were placed in bin.
install(DIRECTORY "${install_location}/bin/"
        DESTINATION "bin"
        USE_SOURCE_PERMISSIONS
        COMPONENT superbuild
        FILES_MATCHING PATTERN "*.dll")

# install the .plugins file
install(FILES "${install_location}/bin/.plugins"
        DESTINATION "bin"
        COMPONENT superbuild)

# install python since (since python dlls are not in the install location)
if (python_ENABLED AND NOT USE_SYSTEM_python)
  # install the Python's modules.
  install(DIRECTORY "${install_location}/bin/Lib"
          DESTINATION "bin"
          USE_SOURCE_PERMISSIONS
          COMPONENT ParaView)

  # install python dlls.
  install(DIRECTORY "${install_location}/bin/"
          DESTINATION "bin"
          USE_SOURCE_PERMISSIONS
          COMPONENT ParaView
          FILES_MATCHING PATTERN "python*.dll")

  # Move the png and zlib dlls into the installed matplotlib package so that it
  # can find them at runtime.
  install(DIRECTORY "${install_location}/bin/"
          DESTINATION "bin/Lib/site-packages/matplotlib"
          USE_SOURCE_PERMISSIONS
          COMPONENT ParaView
          FILES_MATCHING PATTERN "libpng*.dll")
  install(DIRECTORY "${install_location}/bin/"
          DESTINATION "bin/Lib/site-packages/matplotlib"
          USE_SOURCE_PERMISSIONS
          COMPONENT ParaView
          FILES_MATCHING PATTERN "zlib*.dll")
endif()

if (shiboken_ENABLED)
  install(DIRECTORY "${install_location}/bin/Lib/site-packages/smtk"
          DESTINATION "bin/Lib/site-packages"
          USE_SOURCE_PERMISSIONS
          COMPONENT superbuild)
endif()

if (qt_ENABLED AND NOT USE_SYSTEM_qt)
  install(DIRECTORY
    # install all qt plugins (including sqllite).
    # FIXME: we can reconfigure Qt to be built with inbuilt sqllite support to
    # avoid the need for plugins.
    "${install_location}/plugins/"
    DESTINATION "bin"
    COMPONENT ParaView
    PATTERN "*.dll")
endif()

# install paraview python modules and others.
install(DIRECTORY "${install_location}/lib/paraview-${pv_version}"
        DESTINATION "lib"
        USE_SOURCE_PERMISSIONS
        COMPONENT superbuild
        PATTERN "*.lib" EXCLUDE)

#-----------------------------------------------------------------------------
if (mpi_ENABLED AND NOT USE_SYSTEM_mpi)
  # install MPI executables (the dlls are already installed by a previous rule).
  install(DIRECTORY "${install_location}/bin/"
        DESTINATION "bin"
        USE_SOURCE_PERMISSIONS
        COMPONENT ParaView
        FILES_MATCHING
          PATTERN "mpiexec.exe"
          PATTERN "mpirun.exe"
          PATTERN "ompi*.exe"
          PATTERN "opal*.exe"
          PATTERN "orte*.exe"
        )
  # install the mpi configuration files needed for mpiexec.
  install(DIRECTORY "${install_location}/share/openmpi"
          DESTINATION "share"
          USE_SOURCE_PERMISSIONS
          COMPONENT ParaView)
endif()

if (cmbworkflows_ENABLED)
  install(
    DIRECTORY   "${install_location}/share/cmb/workflows/"
    DESTINATION "share/cmb/workflows/"
    COMPONENT   superbuild)
endif ()
