# Install all ParaView's shared libraries.
install(
  DIRECTORY "${install_location}/lib/paraview-${pv_version}"
  DESTINATION "lib"
  USE_SOURCE_PERMISSIONS
  COMPONENT superbuild)

# Install all cmb's shared libraries.
install(
  DIRECTORY "${install_location}/lib/cmb-${cmb_version}"
  DESTINATION "lib"
  USE_SOURCE_PERMISSIONS
  COMPONENT superbuild)

# Get the right version of paraview projects
foreach (prog IN LISTS cmb_programs_to_install)
  if (prog STREQUAL "paraview")
    set(programs_path ${install_location}/lib/paraview-${pv_version}/${prog})
  else ()
    set(programs_path ${install_location}/lib/cmb-${cmb_version}/${prog})
  endif ()

  install(CODE
    "execute_process(COMMAND
       ${CMAKE_COMMAND}
         -Dexecutable:PATH=${programs_path}
         -Ddependencies_root:PATH=${install_location}
         -Dpv_libraries_root:PATH=${install_location}/lib/paraview-${pv_version}
         -Dcmb_libraries_root:PATH=${install_location}/lib/cmb-${cmb_version}
         -Dtarget_root:PATH=\${CMAKE_INSTALL_PREFIX}/lib/paraview-${pv_version}
         -P ${CMAKE_CURRENT_LIST_DIR}/install_dependencies.cmake)"
    COMPONENT superbuild)
endforeach ()

# Install qt
if (qt_ENABLED AND NOT USE_SYSTEM_qt)
  install(
    # Install all qt plugins (including sqlite).
    # FIXME: We can reconfigure Qt to be built with inbuilt sqllite support to
    # avoid the need for plugins.
    DIRECTORY "${install_location}/plugins/"
    DESTINATION "bin"
    COMPONENT superbuild
    PATTERN "*.a" EXCLUDE
    PATTERN "paraview-${pv_version}" EXCLUDE
    PATTERN "${program}-${cmb_version}" EXCLUDE
    PATTERN "fontconfig" EXCLUDE
    PATTERN "*.jar" EXCLUDE
    PATTERN "*.debug.*" EXCLUDE
    PATTERN "libboost*" EXCLUDE)
endif()

# install executables
set(executables pvserver pvdataserver pvrenderserver)
if (python_ENABLED)
  list(APPEND executables
    pvbatch pvpython)
  # we are not building pvblot for now. Disable it.
  # set (executables ${executables} pvblot)
endif ()
if (qt_ENABLED)
  list(APPEND executables
    paraview)
endif ()

foreach (executable IN LISTS executables cmb_programs_to_install)
  install(PROGRAMS "${install_location}/bin/${executable}"
    DESTINATION "bin"
    COMPONENT superbuild)
endforeach ()

if (cmbworkflows_ENABLED)
  install(
    DIRECTORY   "${install_location}/share/cmb/workflows/"
    DESTINATION "share/cmb/workflows/"
    COMPONENT   superbuild)
endif ()
