add_external_project(
  hdf5
  DEPENDS zlib szip

  #always build in release mode.
  #enable install name so that we get full paths to library on apple
  CMAKE_ARGS
    -DCMAKE_BUILD_TYPE:STRING=Release
    -DBUILD_SHARED_LIBS:BOOL=TRUE
    -DHDF5_ENABLE_Z_LIB_SUPPORT:BOOL=TRUE
    -DHDF5_ENABLE_SZIP_SUPPORT:BOOL=TRUE
    -DHDF5_ENABLE_SZIP_ENCODING:BOOL=TRUE
    -DHDF5_BUILD_HL_LIB:BOOL=TRUE
    -DHDF5_BUILD_WITH_INSTALL_NAME:BOOL=TRUE

  LOG_BUILD 1
  LOG_INSTALL 1
)

if (MSVC)
  # hdf5 has a bug with MSVC compiler where it doesn't realize its using MSVC
  # compiler when using nmake or ninja generators. This patch fixes that.
  add_external_project_step(hdf5-patch-detect-msvc
    COMMAND ${CMAKE_COMMAND} -E copy_if_different
    ${SuperBuild_PROJECTS_DIR}/patches/hdf5.config.cmake.ConfigureChecks.cmake
    <SOURCE_DIR>/config/cmake/ConfigureChecks.cmake
    DEPENDEES update # do after update
    DEPENDERS patch  # do before patch
    )
endif()
