
#We only have to do this special installation of the smtk libraries as a plugin
#on MAC

file(REMOVE_RECURSE "${TMP_DIR}/SMTKPlugin")
file(MAKE_DIRECTORY "${TMP_DIR}/SMTKPlugin")

set(plugin_install_dir ${INSTALL_DIR}/Applications/ModelBuilder.app/Contents/Python/smtk)
file(MAKE_DIRECTORY "${plugin_install_dir}")

set(py_files_libs ${SMTK_BIN_DIR}/lib/python${PYTHON_VERSION}/site-packages/smtk/smtkCorePython.so
                  ${SMTK_BIN_DIR}/lib/libshiboken-python${PYTHON_VERSION}.1.2.dylib
                  ${SMTK_BIN_DIR}/lib/python${PYTHON_VERSION}/site-packages/shiboken.so
                  ${SMTK_BIN_DIR}/lib/python${PYTHON_VERSION}/site-packages/smtk/simple.py)
foreach(lib IN LISTS py_files_libs)
  configure_file(
    "${lib}"
    "${TMP_DIR}/SMTKPlugin"
    COPYONLY)
endforeach()

execute_process(
  COMMAND ${CMAKE_CURRENT_LIST_DIR}/fixup_smtk_python.py
          # The directory containing the plugin dylibs.
          ${TMP_DIR}/SMTKPlugin
          # fixup only the id of the plugins based on this string
          ""
          )

execute_process(
  COMMAND ${CMAKE_CURRENT_LIST_DIR}/../remove_code.py
          ${SMTK_BIN_DIR}/lib/python${PYTHON_VERSION}/site-packages/smtk/__init__.py
          ${TMP_DIR}/SMTKPlugin/__init__.py
          )

#okay the plugin is fixed up, now we need to install it into paraviews bundle
file(GLOB fixedUpLibs "${TMP_DIR}/SMTKPlugin/*")
foreach(lib IN LISTS fixedUpLibs)
  message(STATUS "Installing plugin: ${lib}")
  configure_file(
    "${lib}"
    "${plugin_install_dir}"
    COPYONLY)
endforeach()
