//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef smtk_simulation_ace3p_qt_qtCloudClusterWidget
#define smtk_simulation_ace3p_qt_qtCloudClusterWidget

#include <QDialog>
#include <QMutex>
#include <QPixmap>
#include <QTime>
#include <QTimer>

#include "smtk/simulation/ace3p/qt/Exports.h"

namespace Ui
{
class qtCloudClusterWidget;
}

/**
 * \brief Displays the AWS Clusters that are available.
 */
class SMTKACE3PQTEXT_EXPORT qtCloudClusterWidget : public QDialog
{
  Q_OBJECT

public:
  explicit qtCloudClusterWidget(QWidget* parent = nullptr);
  ~qtCloudClusterWidget();

  /** @brief Sets the JSON data to be displayed in the table widget. */
  void setData(const QString &jsonData);

private slots:
  void on_pushButton_Close_clicked();

private:
  Ui::qtCloudClusterWidget* ui;

};

#endif // smtk_simulation_ace3p_qt_qtCloudClusterWidget
