//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#include "qtCloudClusterWidget.h"
#include "ui_qtCloudClusterWidget.h"

//#include <QApplication>
//#include <QCoreApplication>
#include <QJsonArray>
#include <QJsonDocument>
#include <QJsonObject>

// constructor
qtCloudClusterWidget::qtCloudClusterWidget(QWidget* parent)
  : QDialog(parent)
  , ui(new Ui::qtCloudClusterWidget)
{
  this->ui->setupUi(this);

  this->setWindowTitle("AWS Clusters");
  this->setMinimumSize(500, 260);

  // hide the question mark in the Window Title Bar
  this->setWindowFlags(this->windowFlags() & ~Qt::WindowContextHelpButtonHint);

  this->ui->tableWidget->setColumnCount(5);
  QStringList headers = { "Name", "Status", "Instance Type", "Max Instances", "Region" };
  this->ui->tableWidget->setHorizontalHeaderLabels(headers);
  this->ui->tableWidget->setSelectionBehavior(QAbstractItemView::SelectRows);
  this->ui->tableWidget->setSelectionMode(QAbstractItemView::SingleSelection);
  this->ui->tableWidget->setEditTriggers(QAbstractItemView::NoEditTriggers);
}

// destructor
qtCloudClusterWidget::~qtCloudClusterWidget()
{
  delete ui;
}

void qtCloudClusterWidget::on_pushButton_Close_clicked()
{
  this->close();
  this->deleteLater();
}

void qtCloudClusterWidget::setData(const QString &jsonData)
{
  // get JSON array
  QJsonObject data = QJsonDocument::fromJson(jsonData.toUtf8()).object();
  QJsonArray array = data["clusters"].toArray();

  // add array items to tabelWidget
  this->ui->tableWidget->setRowCount(array.count());
  for (int i=0; i<array.count(); i++ )
  {
    QJsonObject entry = array[i].toObject();

    QTableWidgetItem * item = new QTableWidgetItem(entry.value("name").toString());
    this->ui->tableWidget->setItem(i, 0, item);
    item = new QTableWidgetItem(entry.value("status").toString());
    this->ui->tableWidget->setItem(i, 1, item);
    item = new QTableWidgetItem(entry.value("instance_type").toString());
    this->ui->tableWidget->setItem(i, 2, item);
    item = new QTableWidgetItem(QString("%1").arg(entry.value("max_instances").toInt()));
    this->ui->tableWidget->setItem(i, 3, item);
    item = new QTableWidgetItem(entry.value("region").toString());
    this->ui->tableWidget->setItem(i, 4, item);
  }
}
