//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
#ifndef pqACE3PCloudAWSBehavior_h
#define pqACE3PCloudAWSBehavior_h

#include "pqReaction.h"

#include <QObject>

/** \brief Set of behaviors for AWS interaction
  */
class pqACE3PCloudAWSBehavior : public QObject
{
  Q_OBJECT
  using Superclass = QObject;

public:
  static pqACE3PCloudAWSBehavior* instance(QObject* parent = nullptr);
  ~pqACE3PCloudAWSBehavior() override;

public slots:
  void listClusters();

protected:
  pqACE3PCloudAWSBehavior(QObject* parent = nullptr);

private:
  Q_DISABLE_COPY(pqACE3PCloudAWSBehavior);
};

#endif
