//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
#include "pqACE3PCloudAWSBehavior.h"

#include "smtk/newt/qtNewtInterface.h"

#include "smtk/simulation/ace3p/qt/qtCloudClusterWidget.h"

#include "pqCoreUtilities.h"

#include <QDebug>
#include <QMessageBox>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QString>

//-----------------------------------------------------------------------------
static pqACE3PCloudAWSBehavior* g_instance = nullptr;

//-----------------------------------------------------------------------------
pqACE3PCloudAWSBehavior::pqACE3PCloudAWSBehavior(QObject* parent)
  : Superclass(parent)
{
}

//-----------------------------------------------------------------------------
pqACE3PCloudAWSBehavior* pqACE3PCloudAWSBehavior::instance(QObject* parent)
{
  if (!g_instance)
  {
    g_instance = new pqACE3PCloudAWSBehavior(parent);
  }

  if (g_instance->parent() == nullptr && parent)
  {
    g_instance->setParent(parent);
  }

  return g_instance;
}

//-----------------------------------------------------------------------------
pqACE3PCloudAWSBehavior::~pqACE3PCloudAWSBehavior()
{
  if (g_instance == this)
  {
    g_instance = nullptr;
  }

  QObject::disconnect(this);
}

//-----------------------------------------------------------------------------
void pqACE3PCloudAWSBehavior::listClusters()
{
  qDebug() << "AWS List Clusters";

  // Use placeholder logic to get example clusters.json
  QNetworkAccessManager* networkManager = ::newt::qtNewtInterface::instance()->networkAccessManager();
  QString url = QString("https://f001.backblazeb2.com/file/kitware/ace3p/shared/clusters.json");
  QNetworkRequest request(url);
  QNetworkReply* reply = networkManager->get(request);
  QObject::connect(reply, &QNetworkReply::finished, [reply]() {
    if (reply->error() != QNetworkReply::NoError)
    {
      QMessageBox::critical(pqCoreUtilities::mainWidget(), "Network Error", reply->errorString());
      reply->deleteLater();
      return;
    }

    QString text = reply->readAll().constData();
    qtCloudClusterWidget * clusterWidget = new qtCloudClusterWidget(pqCoreUtilities::mainWidget());
    clusterWidget->setData(text);
    clusterWidget->show();

    reply->deleteLater();
  });
}
