"""
Script to query girder instance for items corresponding to simulation assets.
SALI = Simulation Asset Location Index

"""

import argparse
import json
import os

from client import sali_client

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Query SALI for remote asset locations')
    parser.add_argument('keyfile', help='json file with girder url and apikey strings')
    parser.add_argument('modelfile', help='model file')

    args = parser.parse_args()
    # print(args)

    # Read keyfile
    with open(args.keyfile) as fp:
        js = json.load(fp)
        girder_url = js['url']
        apikey = js['apikey']
    if girder_url is None:
        raise RuntimeError('key file missing girder_url')
    if apikey is None:
        raise RuntimeError('key file missing apikey')

    # Make sure model file exists
    if not os.path.exists(args.modelfile):
        raise RuntimeError('Model file not found at {}'.format(args.modelfile))

    sali = sali_client.SALIClient(girder_url, apikey)

    # Call query for the input model file
    result = sali.query(args.modelfile)
    print('query result:', result)

    print('finis')
