//=============================================================================
//
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//=============================================================================
#include "smtk/simulation/ace3p/Registrar.h"
#include "smtk/simulation/ace3p/Project.h"
#include "smtk/simulation/ace3p/Metadata.h"


#include "smtk/simulation/ace3p/operations/Create.h"
#include "smtk/simulation/ace3p/operations/Export.h"
#include "smtk/simulation/ace3p/operations/Read.h"
#include "smtk/simulation/ace3p/operations/Write.h"
#include "smtk/simulation/ace3p/operations/NewAnalysis.h"

#include "smtk/project/Metadata.h"
#include "smtk/project/Manager.h"
#include "smtk/resource/Manager.h"

#include <cassert>
#include <tuple>

namespace smtk
{
namespace simulation
{
namespace ace3p
{
namespace
{
typedef std::tuple<Create, Export, Read, Write, NewAnalysis> OperationList;
typedef std::tuple<> ResourceList;
}

void Registrar::registerTo(const smtk::project::Manager::Ptr& projectManager)
{
  smtk::project::Project::Index index = std::hash<std::string>{}(Metadata::PROJECT_TYPENAME);

  projectManager->registerProject
  (
    smtk::project::Metadata
    (
      Metadata::PROJECT_TYPENAME, index,
      Project::metaCreate, {}, {"Create", "Export", "Read", "Write", "NewAnalysis"}
    )
  );
  bool didRegister = projectManager->registerOperations<OperationList>();
  assert(didRegister);
}

void Registrar::unregisterFrom(const smtk::project::Manager::Ptr& projectManager)
{
  projectManager->unregisterProject(Metadata::PROJECT_TYPENAME);
  projectManager->unregisterOperations<OperationList>();
}

void Registrar::registerTo(const smtk::operation::Manager::Ptr& operationManager)
{
  // not used/needed?
  //operationManager->registerOperations<OperationList>();
}

void Registrar::unregisterFrom(const smtk::operation::Manager::Ptr& operationManager)
{
  // not used/needed?
  //operationManager->unregisterOperations<OperationList>();
}

void Registrar::registerTo(const smtk::resource::Manager::Ptr& resourceManager)
{
  bool didRegister = resourceManager->registerResource<smtk::simulation::ace3p::Project>();
  assert(didRegister);
}

void Registrar::unregisterFrom(const smtk::resource::Manager::Ptr& resourceManager)
{
  resourceManager->unregisterResource<smtk::simulation::ace3p::Project>();
}

}
}
}
