//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
#ifndef smtk_simulation_ace3p_Project_h
#define smtk_simulation_ace3p_Project_h

#include "smtk/simulation/ace3p/Exports.h"

#include "smtk/PublicPointerDefs.h"
#include "smtk/project/Project.h"
#include "smtk/resource/DerivedFrom.h"

#include <string>

namespace smtk
{
namespace simulation
{
namespace ace3p
{

template <typename Self, typename Parent>
using DerivedFrom = smtk::resource::DerivedFrom<Self, Parent>;

class SMTKACE3P_EXPORT Project // : public smtk::project::Project
  : public smtk::resource::DerivedFrom<Project, smtk::project::Project>
{
public:
  smtkTypeMacro(smtk::simulation::ace3p::Project);
  smtkCreateMacro(smtk::project::Project);

  static smtk::project::ProjectPtr metaCreate(const smtk::common::UUID& uuid)
  {
    auto ace3pProject = std::shared_ptr<smtk::simulation::ace3p::Project>(new smtk::simulation::ace3p::Project());
    auto smtkProject = std::static_pointer_cast<smtk::project::Project>(ace3pProject);
    return smtkProject;
  }

  virtual ~Project() {}

protected:
  Project();
};

} // namespace ace3p
} // namespace simulation
} // namespace smtk

#endif
