//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
#ifndef smtk_common_testing_cxx_randomJobCreator_h
#define smtk_common_testing_cxx_randomJobCreator_h

#include "smtk/simulation/ace3p/JobsManifest.h"

// stl includes
#include <stdlib.h>
#include <time.h>
#include <array>
#include <string>
#include <sstream>
namespace
{
std::array<std::string,50> randomNouns = {
  "coffee",
  "comparison",
  "history",
  "administration",
  "menu",
  "environment",
  "wood",
  "football",
  "emphasis",
  "success",
  "connection",
  "honey",
  "poet",
  "negotiation",
  "way",
  "criticism",
  "drawer",
  "winner",
  "income",
  "election",
  "device",
  "signature",
  "mood",
  "extent",
  "outcome",
  "road",
  "tension",
  "judgment",
  "birthday",
  "marzipan",
  "funeral",
  "literature",
  "presence",
  "reality",
  "estate",
  "chocolate",
  "cabinet",
  "cell",
  "manager",
  "clothes",
  "examination",
  "effort",
  "affair",
  "satisfaction",
  "situation",
  "theory",
  "movie",
  "depression",
  "data",
  "yeti"
};
const std::array<std::string,50> randomAdjectives = {
  "lopsided",
  "capable",
  "diligent",
  "cut",
  "royal",
  "nonchalant",
  "absent",
  "actually",
  "near",
  "tall",
  "married",
  "ratty",
  "sordid",
  "pumped",
  "hallowed",
  "measly",
  "red",
  "small",
  "precocious",
  "young",
  "full",
  "careless",
  "harmonious",
  "chemical",
  "cheerful",
  "last",
  "merciful",
  "youthful",
  "tearful",
  "seemly",
  "cruel",
  "thin",
  "useless",
  "absurd",
  "hospitable",
  "sad",
  "beautiful",
  "violent",
  "premium",
  "exotic",
  "well-groomed",
  "nice",
  "technical",
  "green",
  "curved",
  "hanging",
  "excited",
  "asleep",
  "elfin",
  "sharp"
};

inline int randInt(){return rand() % 50;}
inline std::string randNoun(){return randomNouns[randInt()];}
inline std::string randAdj(){return randomAdjectives[randInt()];}
std::string randName()
{
  std::stringstream maker;
  maker << "the " << randAdj() << " " << randNoun();
  return maker.str();
}

std::string randAnalysis()
{
  std::array<std::string,3> s = {
    "omega3p",
    "tem3p",
    "t3p"
  };
  return s[rand() % 3];
}

bool randIsSet = false;
}



// create a random job
inline nlohmann::json randomJob()
{
  if(!randIsSet)
  {
    srand(time(NULL));
    randIsSet = true;
  }

  auto jrg = smtk::simulation::ace3p::JobRecordGenerator();

  int nNodes = rand() % 4096;

  std::stringstream noteMaker;
  noteMaker <<  randName() << " ran with " << randName();

  std::stringstream folderMaker;
  folderMaker << "/project/" << randNoun() << "/ace3p/210420";

  // fill out Job Record form
  jrg.slurmID("8675309");
  jrg.cumulusID("1908u90ua_12394u0ac_1349u");
  jrg.jobName(randName());
  jrg.machine("Cori");
  jrg.analysis(randAnalysis());
  jrg.analysisID("61b77f4e-42fa-4d4f-bcf6-4f39dce77145");
  jrg.nodes(nNodes);
  jrg.processes(nNodes * 24);
  jrg.runtime(rand() % 525600);
  jrg.submissionTime("2018-12-10T13:45:00.000Z");
  jrg.notes(noteMaker.str());
  jrg.runtimeJobFolder(folderMaker.str());
  folderMaker << "/out";
  jrg.localJobFolder(folderMaker.str());

  return jrg.get();
}
#endif
