//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
#ifndef smtk_simulation_ace3p_qt_qtJobsModel_h
#define smtk_simulation_ace3p_qt_qtJobsModel_h

#include "smtk/simulation/ace3p/qt/Exports.h"

// Qt includes
#include <QAbstractTableModel>

// smtk includes
#include "smtk/simulation/ace3p/Project.h"

#include <array>
#include <string>

namespace smtk
{
namespace simulation
{
namespace ace3p
{

class SMTKACE3PQTEXT_EXPORT qtJobsModel : public QAbstractTableModel
{
  Q_OBJECT
  using Superclass = QAbstractTableModel;
public:
  qtJobsModel(QWidget* parent);
  virtual ~qtJobsModel() = default;

  enum JobsFields {
    JobName = 0,
    AnalysisType,
    Status,
    StartTime,
    Notes,
    SlurmID,
    Processes,
    Nodes,
    Machine,
    RemoteDir,
    LocalDir,
    InputDir
  };

  int rowCount(const QModelIndex &parent = QModelIndex())const override;
  int columnCount(const QModelIndex &parent = QModelIndex()) const override;
  QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const override;
  QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const override;
  bool setData(const QModelIndex &index, const QVariant &value, int role = Qt::EditRole) override;
  Qt::ItemFlags flags(const QModelIndex & index) const override;

public slots:
  void populateJobs(const smtk::project::ProjectPtr project);
  void updateJobs();

private:
  // job record field names by column
  std::string col2field(JobsFields col) const;

  // column titles
  const QStringList m_headers = {
    "Name",
    "Analysis",
    "Status",
    "Start Time",
    "", "", "", "", "", "", "", ""
  };

  // number of columns in the table
  const int m_nCols = 12;

  // @brief pointer to the current project
  std::shared_ptr<smtk::simulation::ace3p::Project> m_project = nullptr;
};
}
}
}
#endif
