//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
// .NAME job.h
// .SECTION Description
// .SECTION See Also

#ifndef __smtk_extension_cumulus_job_h
#define __smtk_extension_cumulus_job_h

#include "smtk/cumulus/jobspanel/Exports.h"

#include <QDateTime>
#include <QList>
#include <QMetaType>
#include <QString>

struct cJSON;

namespace cumulus
{

class SMTKCUMULUS_EXPORT Job
{
public:
  Job();
  Job(
    const QString& id,
    const QString& name,
    const QString& status,
    const QList<QString>& outputFolderIds,
    const QString& machine,
    const QString& queueJobId);
  Job(const Job& job);

  ~Job();
  QString id() const { return m_id; };
  QString name() const { return m_name; };
  QString status() const { return m_status; };
  QString machine() const { return m_machine; };
  QList<QString> outputFolderIds() const { return m_outputFolderIds; };
  QString notes() const { return m_notes; };
  int numberOfNodes() const { return m_numberOfNodes; }
  int numberOfCores() const { return m_numberOfCores; }
  QDateTime started() const { return m_start; };
  QDateTime finished() const { return m_finish; };
  QString downloadFolder() const { return m_downloadFolder; }
  QString queueJobId() const { return m_queueJobId; }

  bool isValid() const { return !m_id.isEmpty(); };
  void setStatus(const QString& status);
  void setDownloadFolder(const QString& path);

  static Job fromJSON(cJSON* obj);

  // Copy cmb-specific data to json (for patch request)
  cJSON* cmbDataToJSON() const;

private:
  QString m_id;
  QString m_name;
  QString m_status;
  QString m_machine;
  QList<QString> m_outputFolderIds;
  QString m_notes;
  int m_numberOfNodes;
  int m_numberOfCores;
  QDateTime m_start;
  QDateTime m_finish;
  QString m_downloadFolder;
  QString m_queueJobId;
};

}; // namespace cumulus

Q_DECLARE_METATYPE(cumulus::Job)

#endif
