/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.hanim;

import java.util.HashMap;
import org.j3d.geom.hanim.HAnimDisplacer;
import org.j3d.geom.hanim.HAnimFactory;
import org.j3d.geom.hanim.HAnimObject;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLHAnimNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseGeometricPropertyNode;

public abstract class BaseHAnimDisplacer
extends BaseGeometricPropertyNode
implements VRMLHAnimNodeType {
    protected static final int FIELD_COORD_INDEX = 1;
    protected static final int FIELD_DISPLACEMENTS = 2;
    protected static final int FIELD_NAME = 3;
    protected static final int LAST_DISPLACER_INDEX = 3;
    private static final int NUM_FIELDS = 4;
    protected static final String DISPLACEMENT_PROTO_MSG = "Proto does not describe a Coordinate object";
    protected static final String DISPLACEMENT_NODE_MSG = "Node does not describe a Coordinate object";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected int[] vfCoordIndex = FieldConstants.EMPTY_MFINT32;
    protected int numCoordIndex;
    protected float[] vfDisplacements = FieldConstants.EMPTY_MFFLOAT;
    protected int numDisplacements;
    protected String vfName = null;
    protected HAnimDisplacer hanimImpl;
    protected HAnimFactory hanimFactory;

    public BaseHAnimDisplacer() {
        super("HAnimDisplacer");
        this.hasChanged = new boolean[4];
    }

    public BaseHAnimDisplacer(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("coordIndex");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfCoordIndex = new int[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfCoordIndex, 0, vRMLFieldData.numElements);
                this.numCoordIndex = vRMLFieldData.numElements;
            }
            n = vRMLNodeType.getFieldIndex("name");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfName = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("displacements");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfDisplacements = new float[vRMLFieldData.numElements * 3];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfDisplacements, 0, vRMLFieldData.numElements * 3);
                this.numDisplacements = vRMLFieldData.numElements * 3;
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setHAnimFactory(HAnimFactory hAnimFactory) {
        this.hanimFactory = hAnimFactory;
        this.hanimImpl = hAnimFactory.createDisplacer();
        this.hanimImpl.setName(this.vfName);
        this.hanimImpl.setCoordIndex(this.vfCoordIndex, this.numCoordIndex);
        this.hanimImpl.setDisplacements(this.vfDisplacements, this.numDisplacements);
    }

    public HAnimObject getHAnimObject() {
        return this.hanimImpl;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 20;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.intArrayValue = this.vfCoordIndex;
                vRMLFieldData.dataType = (short)9;
                vRMLFieldData.numElements = this.numCoordIndex;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfDisplacements;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numDisplacements / 3;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.stringValue = this.vfName;
                vRMLFieldData.dataType = (short)6;
                vRMLFieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfCoordIndex, this.numCoordIndex);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfDisplacements, this.numDisplacements);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfName);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.setCoordIndex(nArray, n2);
                break;
            }
            default: {
                super.setValue(n, nArray, n2);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 2: {
                this.setDisplacements(fArray, n2);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException {
        switch (n) {
            case 3: {
                this.vfName = string;
                if (this.inSetup) break;
                this.hanimImpl.setName(this.vfName);
                this.hasChanged[3] = true;
                this.fireFieldChanged(3);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    protected void setDisplacements(float[] fArray, int n) throws InvalidFieldValueException {
        if (n > this.vfDisplacements.length) {
            this.vfDisplacements = new float[n];
        }
        this.numDisplacements = n;
        System.arraycopy(fArray, 0, this.vfDisplacements, 0, this.numDisplacements);
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    protected void setCoordIndex(int[] nArray, int n) throws InvalidFieldValueException {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] >= -1) continue;
            throw new InvalidFieldValueException("The value at index " + i + " is less than -1");
        }
        if (this.vfCoordIndex == null || n > this.vfCoordIndex.length) {
            this.vfCoordIndex = new int[n];
        }
        this.numCoordIndex = n;
        System.arraycopy(nArray, 0, this.vfCoordIndex, 0, this.numCoordIndex);
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    static {
        nodeFields = new int[]{0, 2};
        fieldDecl = new VRMLFieldDeclaration[4];
        fieldMap = new HashMap(12);
        BaseHAnimDisplacer.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseHAnimDisplacer.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFInt32", "coordIndex");
        BaseHAnimDisplacer.fieldDecl[2] = new VRMLFieldDeclaration(3, "MFFloat", "displacements");
        BaseHAnimDisplacer.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFString", "name");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("coordIndex", n);
        fieldMap.put("set_coordIndex", n);
        fieldMap.put("coordIndex_changed", n);
        n = new Integer(2);
        fieldMap.put("displacements", n);
        fieldMap.put("set_displacements", n);
        fieldMap.put("displacements_changed", n);
        n = new Integer(3);
        fieldMap.put("name", n);
        fieldMap.put("set_name", n);
        fieldMap.put("name_changed", n);
    }
}

