/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.render;

import java.util.HashMap;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseIndexedTriangleGeometryNode;

public abstract class BaseIndexedTriangleStripSet
extends BaseIndexedTriangleGeometryNode {
    private static final int NUM_FIELDS = 13;
    private static final String MAX_INDEX_COUNT_MSG = "Max coordIndex value > number of coords in IndexedTriangleStripSet";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    private int[][] vertexToFace;
    protected int[] stripCounts;
    protected int numStripCounts;
    private int maxIndexValue;
    protected int[] processedIndex;
    protected int numProcessedIndex;

    protected BaseIndexedTriangleStripSet() {
        super("IndexedTriangleStripSet");
        this.hasChanged = new boolean[13];
    }

    protected BaseIndexedTriangleStripSet(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLComponentGeometryNodeType)vRMLNodeType);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 12) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    protected void updateIndexMaps() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.processedIndex == null || this.processedIndex.length < this.numIndex) {
            this.processedIndex = new int[this.numIndex];
        }
        this.numStripCounts = 1;
        for (n4 = 0; n4 < this.numIndex - 1; ++n4) {
            if (this.vfIndex[n4] != -1) continue;
            ++this.numStripCounts;
        }
        if (this.stripCounts == null || this.stripCounts.length < this.numStripCounts) {
            this.stripCounts = new int[this.numStripCounts];
        }
        n4 = 0;
        this.numProcessedIndex = 0;
        for (n3 = 0; n3 < this.numIndex; ++n3) {
            if (this.vfIndex[n3] == -1) {
                ++n4;
                continue;
            }
            this.processedIndex[this.numProcessedIndex++] = this.vfIndex[n3];
            int n5 = n4;
            this.stripCounts[n5] = this.stripCounts[n5] + 1;
        }
        this.maxIndexValue = 0;
        for (n3 = 0; n3 < this.numProcessedIndex; ++n3) {
            if (this.processedIndex[n3] <= this.maxIndexValue) continue;
            this.maxIndexValue = this.processedIndex[n3];
        }
        if (this.vfCoord != null && (this.maxIndexValue + 1) * 3 > this.vfCoord.getNumPoints()) {
            this.errorReporter.warningReport(MAX_INDEX_COUNT_MSG, null);
        }
        if (this.vertexToFace == null || this.vertexToFace.length < this.maxIndexValue + 1) {
            this.vertexToFace = new int[this.maxIndexValue + 1][];
        }
        int[] nArray = new int[this.maxIndexValue + 1];
        int n6 = 0;
        for (n2 = 0; n2 < this.numStripCounts; ++n2) {
            for (n = 0; n < this.stripCounts[n2] - 1; ++n) {
                int n7 = this.processedIndex[n6];
                nArray[n7] = nArray[n7] + 1;
                int n8 = this.processedIndex[n6 + 1];
                nArray[n8] = nArray[n8] + 1;
                ++n6;
            }
        }
        for (n2 = 0; n2 < this.maxIndexValue + 1; ++n2) {
            if (this.vertexToFace[n2] != null && this.vertexToFace[n2].length == nArray[n2]) continue;
            this.vertexToFace[n2] = new int[nArray[n2]];
        }
        for (n2 = 0; n2 < this.maxIndexValue + 1; ++n2) {
            nArray[n2] = 0;
        }
        n2 = 0;
        n6 = 0;
        for (n = 0; n < this.numStripCounts; ++n) {
            for (int i = 0; i < this.stripCounts[n] - 2; ++i) {
                int n9 = this.processedIndex[n6];
                int n10 = this.processedIndex[n6 + 1];
                this.vertexToFace[n9][nArray[n9]] = n2;
                this.vertexToFace[n10][nArray[n10]] = n2++;
                int n11 = n9;
                nArray[n11] = nArray[n11] + 1;
                int n12 = n10;
                nArray[n12] = nArray[n12] + 1;
                ++n6;
            }
        }
    }

    static {
        nodeFields = new int[]{1, 3, 4, 2, 0};
        fieldDecl = new VRMLFieldDeclaration[13];
        fieldMap = new HashMap(39);
        BaseIndexedTriangleStripSet.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseIndexedTriangleStripSet.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "coord");
        BaseIndexedTriangleStripSet.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFNode", "texCoord");
        BaseIndexedTriangleStripSet.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "color");
        BaseIndexedTriangleStripSet.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFNode", "normal");
        BaseIndexedTriangleStripSet.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFBool", "solid");
        BaseIndexedTriangleStripSet.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFBool", "ccw");
        BaseIndexedTriangleStripSet.fieldDecl[7] = new VRMLFieldDeclaration(2, "SFBool", "colorPerVertex");
        BaseIndexedTriangleStripSet.fieldDecl[8] = new VRMLFieldDeclaration(2, "SFBool", "normalPerVertex");
        BaseIndexedTriangleStripSet.fieldDecl[11] = new VRMLFieldDeclaration(2, "MFInt32", "index");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("coord", n);
        fieldMap.put("set_coord", n);
        fieldMap.put("coord_changed", n);
        n = new Integer(4);
        fieldMap.put("texCoord", n);
        fieldMap.put("set_texCoord", n);
        fieldMap.put("texCoord_changed", n);
        n = new Integer(2);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
        n = new Integer(3);
        fieldMap.put("normal", n);
        fieldMap.put("set_normal", n);
        fieldMap.put("normal_changed", n);
        fieldMap.put("solid", new Integer(5));
        fieldMap.put("ccw", new Integer(6));
        fieldMap.put("colorPerVertex", new Integer(7));
        fieldMap.put("normalPerVertex", new Integer(8));
        fieldMap.put("index", new Integer(11));
        fieldMap.put("set_index", new Integer(12));
    }
}

