/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.impl.core.eventmodel;

import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.ComponentInfo;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLHAnimHumanoidNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.util.NodeArray;
import org.xj3d.core.eventmodel.NodeManager;

public class DefaultHumanoidManager
implements NodeManager {
    private static final int[] MANAGED_NODE_TYPES = new int[]{77};
    private ErrorReporter errorReporter;
    private NodeArray humanoids = new NodeArray();

    public DefaultHumanoidManager() {
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public boolean initialize() {
        return true;
    }

    public void shutdown() {
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public ComponentInfo[] getSupportedComponents() {
        return new ComponentInfo[]{new ComponentInfo("H-Anim", 1)};
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
    }

    public void resetTimeZero() {
    }

    public int[] getManagedNodeTypes() {
        return MANAGED_NODE_TYPES;
    }

    public boolean evaluatePreEventModel() {
        return false;
    }

    public boolean evaluatePostEventModel() {
        return true;
    }

    public void addManagedNode(VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLHAnimHumanoidNodeType)) {
            this.errorReporter.warningReport("Non-HAnim node added to the manager", null);
            return;
        }
        this.humanoids.add(vRMLNodeType);
    }

    public void removeManagedNode(VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLHAnimHumanoidNodeType)) {
            this.errorReporter.warningReport("Non-HAnim node removed from the manager", null);
            return;
        }
        this.humanoids.remove(vRMLNodeType);
    }

    public void executePreEventModel(long l) {
    }

    public void executePostEventModel(long l) {
        int n = this.humanoids.size();
        for (int i = 0; i < n; ++i) {
            VRMLHAnimHumanoidNodeType vRMLHAnimHumanoidNodeType = (VRMLHAnimHumanoidNodeType)this.humanoids.get(i);
            vRMLHAnimHumanoidNodeType.updateMesh();
        }
    }

    public void clear() {
        this.humanoids.clear();
    }
}

