//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//============================================================================
// **** DO NOT EDIT THIS FILE!!! ****
// This file is automatically generated by WorkletInvokeFunctorDetail.h.in

// Technically speaking, we can implement this functionality with some clever
// use of FunctionInterface rather than using pyexpander to make variadic
// code. However, this code is probably more friendly to compilers. I expect
// it to compiler faster and optimize better.

#ifndef vtk_m_exec_internal_WorkletInvokeFunctorDetail_h
#define vtk_m_exec_internal_WorkletInvokeFunctorDetail_h

#if !defined(vtk_m_exec_internal_TaskSingular_h) && \
    !defined(vtk_m_exec_internal_TaskTiling_h) &&  \
    !defined(vtk_m_exec_cuda_internal_TaskStrided_h) && \
    !defined(VTKM_TEST_HEADER_BUILD)
#error WorkletInvokeFunctorDetail.h must be included from TaskSingular.h, TaskTiling.h, TaskStrided.h
#endif

#include <vtkm/internal/FunctionInterface.h>
#include <vtkm/internal/Invocation.h>

#include <vtkm/exec/arg/Fetch.h>
#include <vtkm/exec/arg/FetchTagExecObject.h>

#if VTKM_MAX_FUNCTION_PARAMETERS != 20
#error Mismatch of maximum parameters between FunctionInterfaceDatailPre.h.in and WorkletInvokeFunctorDetail.h.in
#endif


namespace vtkm
{
namespace exec
{
namespace internal
{
namespace detail
{

struct DummyDeviceControlSignatureTag
{
  using FetchTag = vtkm::exec::arg::FetchTagExecObject;
};

/// A helper class that takes an \c Invocation object and an index to a
/// parameter in the ExecutionSignature and finds the \c Fetch type valid for
/// that parameter.
template <typename ThreadIndicesType,
          typename Invocation,
          vtkm::IdComponent ExecutionParameterIndex>
struct InvocationToFetch
{
  using ExecutionSignatureTag =
    typename Invocation::ExecutionInterface::template ParameterType<ExecutionParameterIndex>::type;

  // Expected fields from ExecutionSignatureTag. If these do not exist in
  // ExecutionSignatureTag, then something that is not really an execution
  // signature tag was used in an ExecutionSignature.
  static constexpr vtkm::IdComponent ControlParameterIndex = ExecutionSignatureTag::INDEX;
  using AspectTag = typename ExecutionSignatureTag::AspectTag;

  // Find the fetch tag from the control signature tag pointed to by
  // ParameterIndex. Note that ControlParameterIndex of 0 is reserved
  // for getting the device adapter tag.
  using ControlInterface = typename Invocation::ControlInterface;
  using ControlSignatureTag =
    typename std::conditional<
      ControlParameterIndex == 0,
      DummyDeviceControlSignatureTag,
      typename ControlInterface::template ParameterType<ControlParameterIndex>::type>::type;
  using FetchTag = typename ControlSignatureTag::FetchTag;

  using ExecObjectType =
    typename std::conditional<
      ControlParameterIndex == 0,
      typename Invocation::DeviceAdapterTag,
      typename Invocation::ParameterInterface::template ParameterType<ControlParameterIndex>::type>::type;

  using type = vtkm::exec::arg::Fetch<FetchTag, AspectTag, ThreadIndicesType, ExecObjectType>;

  VTKM_EXEC static ExecObjectType GetParameterImpl(const Invocation&, std::true_type)
  {
    return typename Invocation::DeviceAdapterTag();
  }

  VTKM_EXEC static ExecObjectType GetParameterImpl(const Invocation& invocation, std::false_type)
  {
    return vtkm::internal::ParameterGet<ControlParameterIndex>(invocation.Parameters);
  }

  VTKM_EXEC static ExecObjectType GetParameter(const Invocation& invocation)
  {
    return GetParameterImpl(invocation, std::integral_constant<bool, ControlParameterIndex == 0>());
  }
};

// clang-format off

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2,
          typename P3>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2, P3)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2, P3)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2, p3);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2,
          typename P3>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2, P3)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2, P3)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2, p3);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2, P3, P4)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2, P3, P4)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2, p3, p4);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2,
          typename P3,
          typename P4>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2, P3, P4)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2, P3, P4)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2, p3, p4);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2, p3, p4, p5);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2, p3, p4, p5);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2, p3, p4, p5, p6);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2, p3, p4, p5, p6);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2, p3, p4, p5, p6, p7);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2, p3, p4, p5, p6, p7);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2, p3, p4, p5, p6, p7, p8);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2, p3, p4, p5, p6, p7, p8);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo12 = InvocationToFetch<ThreadIndicesType, Invocation, 12>;
  using FetchType12 = typename FetchInfo12::type;
  FetchType12 fetch12;
  auto p12 =
    fetch12.Load(threadIndices, FetchInfo12::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
  fetch12.Store(threadIndices, FetchInfo12::GetParameter(invocation), p12);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo12 = InvocationToFetch<ThreadIndicesType, Invocation, 12>;
  using FetchType12 = typename FetchInfo12::type;
  FetchType12 fetch12;
  auto p12 =
    fetch12.Load(threadIndices, FetchInfo12::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
  fetch12.Store(threadIndices, FetchInfo12::GetParameter(invocation), p12);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo12 = InvocationToFetch<ThreadIndicesType, Invocation, 12>;
  using FetchType12 = typename FetchInfo12::type;
  FetchType12 fetch12;
  auto p12 =
    fetch12.Load(threadIndices, FetchInfo12::GetParameter(invocation));

  using FetchInfo13 = InvocationToFetch<ThreadIndicesType, Invocation, 13>;
  using FetchType13 = typename FetchInfo13::type;
  FetchType13 fetch13;
  auto p13 =
    fetch13.Load(threadIndices, FetchInfo13::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
  fetch12.Store(threadIndices, FetchInfo12::GetParameter(invocation), p12);
  fetch13.Store(threadIndices, FetchInfo13::GetParameter(invocation), p13);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo12 = InvocationToFetch<ThreadIndicesType, Invocation, 12>;
  using FetchType12 = typename FetchInfo12::type;
  FetchType12 fetch12;
  auto p12 =
    fetch12.Load(threadIndices, FetchInfo12::GetParameter(invocation));

  using FetchInfo13 = InvocationToFetch<ThreadIndicesType, Invocation, 13>;
  using FetchType13 = typename FetchInfo13::type;
  FetchType13 fetch13;
  auto p13 =
    fetch13.Load(threadIndices, FetchInfo13::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
  fetch12.Store(threadIndices, FetchInfo12::GetParameter(invocation), p12);
  fetch13.Store(threadIndices, FetchInfo13::GetParameter(invocation), p13);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo12 = InvocationToFetch<ThreadIndicesType, Invocation, 12>;
  using FetchType12 = typename FetchInfo12::type;
  FetchType12 fetch12;
  auto p12 =
    fetch12.Load(threadIndices, FetchInfo12::GetParameter(invocation));

  using FetchInfo13 = InvocationToFetch<ThreadIndicesType, Invocation, 13>;
  using FetchType13 = typename FetchInfo13::type;
  FetchType13 fetch13;
  auto p13 =
    fetch13.Load(threadIndices, FetchInfo13::GetParameter(invocation));

  using FetchInfo14 = InvocationToFetch<ThreadIndicesType, Invocation, 14>;
  using FetchType14 = typename FetchInfo14::type;
  FetchType14 fetch14;
  auto p14 =
    fetch14.Load(threadIndices, FetchInfo14::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
  fetch12.Store(threadIndices, FetchInfo12::GetParameter(invocation), p12);
  fetch13.Store(threadIndices, FetchInfo13::GetParameter(invocation), p13);
  fetch14.Store(threadIndices, FetchInfo14::GetParameter(invocation), p14);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo12 = InvocationToFetch<ThreadIndicesType, Invocation, 12>;
  using FetchType12 = typename FetchInfo12::type;
  FetchType12 fetch12;
  auto p12 =
    fetch12.Load(threadIndices, FetchInfo12::GetParameter(invocation));

  using FetchInfo13 = InvocationToFetch<ThreadIndicesType, Invocation, 13>;
  using FetchType13 = typename FetchInfo13::type;
  FetchType13 fetch13;
  auto p13 =
    fetch13.Load(threadIndices, FetchInfo13::GetParameter(invocation));

  using FetchInfo14 = InvocationToFetch<ThreadIndicesType, Invocation, 14>;
  using FetchType14 = typename FetchInfo14::type;
  FetchType14 fetch14;
  auto p14 =
    fetch14.Load(threadIndices, FetchInfo14::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
  fetch12.Store(threadIndices, FetchInfo12::GetParameter(invocation), p12);
  fetch13.Store(threadIndices, FetchInfo13::GetParameter(invocation), p13);
  fetch14.Store(threadIndices, FetchInfo14::GetParameter(invocation), p14);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo12 = InvocationToFetch<ThreadIndicesType, Invocation, 12>;
  using FetchType12 = typename FetchInfo12::type;
  FetchType12 fetch12;
  auto p12 =
    fetch12.Load(threadIndices, FetchInfo12::GetParameter(invocation));

  using FetchInfo13 = InvocationToFetch<ThreadIndicesType, Invocation, 13>;
  using FetchType13 = typename FetchInfo13::type;
  FetchType13 fetch13;
  auto p13 =
    fetch13.Load(threadIndices, FetchInfo13::GetParameter(invocation));

  using FetchInfo14 = InvocationToFetch<ThreadIndicesType, Invocation, 14>;
  using FetchType14 = typename FetchInfo14::type;
  FetchType14 fetch14;
  auto p14 =
    fetch14.Load(threadIndices, FetchInfo14::GetParameter(invocation));

  using FetchInfo15 = InvocationToFetch<ThreadIndicesType, Invocation, 15>;
  using FetchType15 = typename FetchInfo15::type;
  FetchType15 fetch15;
  auto p15 =
    fetch15.Load(threadIndices, FetchInfo15::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
  fetch12.Store(threadIndices, FetchInfo12::GetParameter(invocation), p12);
  fetch13.Store(threadIndices, FetchInfo13::GetParameter(invocation), p13);
  fetch14.Store(threadIndices, FetchInfo14::GetParameter(invocation), p14);
  fetch15.Store(threadIndices, FetchInfo15::GetParameter(invocation), p15);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo12 = InvocationToFetch<ThreadIndicesType, Invocation, 12>;
  using FetchType12 = typename FetchInfo12::type;
  FetchType12 fetch12;
  auto p12 =
    fetch12.Load(threadIndices, FetchInfo12::GetParameter(invocation));

  using FetchInfo13 = InvocationToFetch<ThreadIndicesType, Invocation, 13>;
  using FetchType13 = typename FetchInfo13::type;
  FetchType13 fetch13;
  auto p13 =
    fetch13.Load(threadIndices, FetchInfo13::GetParameter(invocation));

  using FetchInfo14 = InvocationToFetch<ThreadIndicesType, Invocation, 14>;
  using FetchType14 = typename FetchInfo14::type;
  FetchType14 fetch14;
  auto p14 =
    fetch14.Load(threadIndices, FetchInfo14::GetParameter(invocation));

  using FetchInfo15 = InvocationToFetch<ThreadIndicesType, Invocation, 15>;
  using FetchType15 = typename FetchInfo15::type;
  FetchType15 fetch15;
  auto p15 =
    fetch15.Load(threadIndices, FetchInfo15::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
  fetch12.Store(threadIndices, FetchInfo12::GetParameter(invocation), p12);
  fetch13.Store(threadIndices, FetchInfo13::GetParameter(invocation), p13);
  fetch14.Store(threadIndices, FetchInfo14::GetParameter(invocation), p14);
  fetch15.Store(threadIndices, FetchInfo15::GetParameter(invocation), p15);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo12 = InvocationToFetch<ThreadIndicesType, Invocation, 12>;
  using FetchType12 = typename FetchInfo12::type;
  FetchType12 fetch12;
  auto p12 =
    fetch12.Load(threadIndices, FetchInfo12::GetParameter(invocation));

  using FetchInfo13 = InvocationToFetch<ThreadIndicesType, Invocation, 13>;
  using FetchType13 = typename FetchInfo13::type;
  FetchType13 fetch13;
  auto p13 =
    fetch13.Load(threadIndices, FetchInfo13::GetParameter(invocation));

  using FetchInfo14 = InvocationToFetch<ThreadIndicesType, Invocation, 14>;
  using FetchType14 = typename FetchInfo14::type;
  FetchType14 fetch14;
  auto p14 =
    fetch14.Load(threadIndices, FetchInfo14::GetParameter(invocation));

  using FetchInfo15 = InvocationToFetch<ThreadIndicesType, Invocation, 15>;
  using FetchType15 = typename FetchInfo15::type;
  FetchType15 fetch15;
  auto p15 =
    fetch15.Load(threadIndices, FetchInfo15::GetParameter(invocation));

  using FetchInfo16 = InvocationToFetch<ThreadIndicesType, Invocation, 16>;
  using FetchType16 = typename FetchInfo16::type;
  FetchType16 fetch16;
  auto p16 =
    fetch16.Load(threadIndices, FetchInfo16::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
  fetch12.Store(threadIndices, FetchInfo12::GetParameter(invocation), p12);
  fetch13.Store(threadIndices, FetchInfo13::GetParameter(invocation), p13);
  fetch14.Store(threadIndices, FetchInfo14::GetParameter(invocation), p14);
  fetch15.Store(threadIndices, FetchInfo15::GetParameter(invocation), p15);
  fetch16.Store(threadIndices, FetchInfo16::GetParameter(invocation), p16);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo12 = InvocationToFetch<ThreadIndicesType, Invocation, 12>;
  using FetchType12 = typename FetchInfo12::type;
  FetchType12 fetch12;
  auto p12 =
    fetch12.Load(threadIndices, FetchInfo12::GetParameter(invocation));

  using FetchInfo13 = InvocationToFetch<ThreadIndicesType, Invocation, 13>;
  using FetchType13 = typename FetchInfo13::type;
  FetchType13 fetch13;
  auto p13 =
    fetch13.Load(threadIndices, FetchInfo13::GetParameter(invocation));

  using FetchInfo14 = InvocationToFetch<ThreadIndicesType, Invocation, 14>;
  using FetchType14 = typename FetchInfo14::type;
  FetchType14 fetch14;
  auto p14 =
    fetch14.Load(threadIndices, FetchInfo14::GetParameter(invocation));

  using FetchInfo15 = InvocationToFetch<ThreadIndicesType, Invocation, 15>;
  using FetchType15 = typename FetchInfo15::type;
  FetchType15 fetch15;
  auto p15 =
    fetch15.Load(threadIndices, FetchInfo15::GetParameter(invocation));

  using FetchInfo16 = InvocationToFetch<ThreadIndicesType, Invocation, 16>;
  using FetchType16 = typename FetchInfo16::type;
  FetchType16 fetch16;
  auto p16 =
    fetch16.Load(threadIndices, FetchInfo16::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
  fetch12.Store(threadIndices, FetchInfo12::GetParameter(invocation), p12);
  fetch13.Store(threadIndices, FetchInfo13::GetParameter(invocation), p13);
  fetch14.Store(threadIndices, FetchInfo14::GetParameter(invocation), p14);
  fetch15.Store(threadIndices, FetchInfo15::GetParameter(invocation), p15);
  fetch16.Store(threadIndices, FetchInfo16::GetParameter(invocation), p16);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16,
          typename P17>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo12 = InvocationToFetch<ThreadIndicesType, Invocation, 12>;
  using FetchType12 = typename FetchInfo12::type;
  FetchType12 fetch12;
  auto p12 =
    fetch12.Load(threadIndices, FetchInfo12::GetParameter(invocation));

  using FetchInfo13 = InvocationToFetch<ThreadIndicesType, Invocation, 13>;
  using FetchType13 = typename FetchInfo13::type;
  FetchType13 fetch13;
  auto p13 =
    fetch13.Load(threadIndices, FetchInfo13::GetParameter(invocation));

  using FetchInfo14 = InvocationToFetch<ThreadIndicesType, Invocation, 14>;
  using FetchType14 = typename FetchInfo14::type;
  FetchType14 fetch14;
  auto p14 =
    fetch14.Load(threadIndices, FetchInfo14::GetParameter(invocation));

  using FetchInfo15 = InvocationToFetch<ThreadIndicesType, Invocation, 15>;
  using FetchType15 = typename FetchInfo15::type;
  FetchType15 fetch15;
  auto p15 =
    fetch15.Load(threadIndices, FetchInfo15::GetParameter(invocation));

  using FetchInfo16 = InvocationToFetch<ThreadIndicesType, Invocation, 16>;
  using FetchType16 = typename FetchInfo16::type;
  FetchType16 fetch16;
  auto p16 =
    fetch16.Load(threadIndices, FetchInfo16::GetParameter(invocation));

  using FetchInfo17 = InvocationToFetch<ThreadIndicesType, Invocation, 17>;
  using FetchType17 = typename FetchInfo17::type;
  FetchType17 fetch17;
  auto p17 =
    fetch17.Load(threadIndices, FetchInfo17::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
  fetch12.Store(threadIndices, FetchInfo12::GetParameter(invocation), p12);
  fetch13.Store(threadIndices, FetchInfo13::GetParameter(invocation), p13);
  fetch14.Store(threadIndices, FetchInfo14::GetParameter(invocation), p14);
  fetch15.Store(threadIndices, FetchInfo15::GetParameter(invocation), p15);
  fetch16.Store(threadIndices, FetchInfo16::GetParameter(invocation), p16);
  fetch17.Store(threadIndices, FetchInfo17::GetParameter(invocation), p17);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16,
          typename P17>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo12 = InvocationToFetch<ThreadIndicesType, Invocation, 12>;
  using FetchType12 = typename FetchInfo12::type;
  FetchType12 fetch12;
  auto p12 =
    fetch12.Load(threadIndices, FetchInfo12::GetParameter(invocation));

  using FetchInfo13 = InvocationToFetch<ThreadIndicesType, Invocation, 13>;
  using FetchType13 = typename FetchInfo13::type;
  FetchType13 fetch13;
  auto p13 =
    fetch13.Load(threadIndices, FetchInfo13::GetParameter(invocation));

  using FetchInfo14 = InvocationToFetch<ThreadIndicesType, Invocation, 14>;
  using FetchType14 = typename FetchInfo14::type;
  FetchType14 fetch14;
  auto p14 =
    fetch14.Load(threadIndices, FetchInfo14::GetParameter(invocation));

  using FetchInfo15 = InvocationToFetch<ThreadIndicesType, Invocation, 15>;
  using FetchType15 = typename FetchInfo15::type;
  FetchType15 fetch15;
  auto p15 =
    fetch15.Load(threadIndices, FetchInfo15::GetParameter(invocation));

  using FetchInfo16 = InvocationToFetch<ThreadIndicesType, Invocation, 16>;
  using FetchType16 = typename FetchInfo16::type;
  FetchType16 fetch16;
  auto p16 =
    fetch16.Load(threadIndices, FetchInfo16::GetParameter(invocation));

  using FetchInfo17 = InvocationToFetch<ThreadIndicesType, Invocation, 17>;
  using FetchType17 = typename FetchInfo17::type;
  FetchType17 fetch17;
  auto p17 =
    fetch17.Load(threadIndices, FetchInfo17::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
  fetch12.Store(threadIndices, FetchInfo12::GetParameter(invocation), p12);
  fetch13.Store(threadIndices, FetchInfo13::GetParameter(invocation), p13);
  fetch14.Store(threadIndices, FetchInfo14::GetParameter(invocation), p14);
  fetch15.Store(threadIndices, FetchInfo15::GetParameter(invocation), p15);
  fetch16.Store(threadIndices, FetchInfo16::GetParameter(invocation), p16);
  fetch17.Store(threadIndices, FetchInfo17::GetParameter(invocation), p17);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16,
          typename P17,
          typename P18>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo12 = InvocationToFetch<ThreadIndicesType, Invocation, 12>;
  using FetchType12 = typename FetchInfo12::type;
  FetchType12 fetch12;
  auto p12 =
    fetch12.Load(threadIndices, FetchInfo12::GetParameter(invocation));

  using FetchInfo13 = InvocationToFetch<ThreadIndicesType, Invocation, 13>;
  using FetchType13 = typename FetchInfo13::type;
  FetchType13 fetch13;
  auto p13 =
    fetch13.Load(threadIndices, FetchInfo13::GetParameter(invocation));

  using FetchInfo14 = InvocationToFetch<ThreadIndicesType, Invocation, 14>;
  using FetchType14 = typename FetchInfo14::type;
  FetchType14 fetch14;
  auto p14 =
    fetch14.Load(threadIndices, FetchInfo14::GetParameter(invocation));

  using FetchInfo15 = InvocationToFetch<ThreadIndicesType, Invocation, 15>;
  using FetchType15 = typename FetchInfo15::type;
  FetchType15 fetch15;
  auto p15 =
    fetch15.Load(threadIndices, FetchInfo15::GetParameter(invocation));

  using FetchInfo16 = InvocationToFetch<ThreadIndicesType, Invocation, 16>;
  using FetchType16 = typename FetchInfo16::type;
  FetchType16 fetch16;
  auto p16 =
    fetch16.Load(threadIndices, FetchInfo16::GetParameter(invocation));

  using FetchInfo17 = InvocationToFetch<ThreadIndicesType, Invocation, 17>;
  using FetchType17 = typename FetchInfo17::type;
  FetchType17 fetch17;
  auto p17 =
    fetch17.Load(threadIndices, FetchInfo17::GetParameter(invocation));

  using FetchInfo18 = InvocationToFetch<ThreadIndicesType, Invocation, 18>;
  using FetchType18 = typename FetchInfo18::type;
  FetchType18 fetch18;
  auto p18 =
    fetch18.Load(threadIndices, FetchInfo18::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
  fetch12.Store(threadIndices, FetchInfo12::GetParameter(invocation), p12);
  fetch13.Store(threadIndices, FetchInfo13::GetParameter(invocation), p13);
  fetch14.Store(threadIndices, FetchInfo14::GetParameter(invocation), p14);
  fetch15.Store(threadIndices, FetchInfo15::GetParameter(invocation), p15);
  fetch16.Store(threadIndices, FetchInfo16::GetParameter(invocation), p16);
  fetch17.Store(threadIndices, FetchInfo17::GetParameter(invocation), p17);
  fetch18.Store(threadIndices, FetchInfo18::GetParameter(invocation), p18);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16,
          typename P17,
          typename P18>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo12 = InvocationToFetch<ThreadIndicesType, Invocation, 12>;
  using FetchType12 = typename FetchInfo12::type;
  FetchType12 fetch12;
  auto p12 =
    fetch12.Load(threadIndices, FetchInfo12::GetParameter(invocation));

  using FetchInfo13 = InvocationToFetch<ThreadIndicesType, Invocation, 13>;
  using FetchType13 = typename FetchInfo13::type;
  FetchType13 fetch13;
  auto p13 =
    fetch13.Load(threadIndices, FetchInfo13::GetParameter(invocation));

  using FetchInfo14 = InvocationToFetch<ThreadIndicesType, Invocation, 14>;
  using FetchType14 = typename FetchInfo14::type;
  FetchType14 fetch14;
  auto p14 =
    fetch14.Load(threadIndices, FetchInfo14::GetParameter(invocation));

  using FetchInfo15 = InvocationToFetch<ThreadIndicesType, Invocation, 15>;
  using FetchType15 = typename FetchInfo15::type;
  FetchType15 fetch15;
  auto p15 =
    fetch15.Load(threadIndices, FetchInfo15::GetParameter(invocation));

  using FetchInfo16 = InvocationToFetch<ThreadIndicesType, Invocation, 16>;
  using FetchType16 = typename FetchInfo16::type;
  FetchType16 fetch16;
  auto p16 =
    fetch16.Load(threadIndices, FetchInfo16::GetParameter(invocation));

  using FetchInfo17 = InvocationToFetch<ThreadIndicesType, Invocation, 17>;
  using FetchType17 = typename FetchInfo17::type;
  FetchType17 fetch17;
  auto p17 =
    fetch17.Load(threadIndices, FetchInfo17::GetParameter(invocation));

  using FetchInfo18 = InvocationToFetch<ThreadIndicesType, Invocation, 18>;
  using FetchType18 = typename FetchInfo18::type;
  FetchType18 fetch18;
  auto p18 =
    fetch18.Load(threadIndices, FetchInfo18::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
  fetch12.Store(threadIndices, FetchInfo12::GetParameter(invocation), p12);
  fetch13.Store(threadIndices, FetchInfo13::GetParameter(invocation), p13);
  fetch14.Store(threadIndices, FetchInfo14::GetParameter(invocation), p14);
  fetch15.Store(threadIndices, FetchInfo15::GetParameter(invocation), p15);
  fetch16.Store(threadIndices, FetchInfo16::GetParameter(invocation), p16);
  fetch17.Store(threadIndices, FetchInfo17::GetParameter(invocation), p17);
  fetch18.Store(threadIndices, FetchInfo18::GetParameter(invocation), p18);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16,
          typename P17,
          typename P18,
          typename P19>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18, P19)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18, P19)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo12 = InvocationToFetch<ThreadIndicesType, Invocation, 12>;
  using FetchType12 = typename FetchInfo12::type;
  FetchType12 fetch12;
  auto p12 =
    fetch12.Load(threadIndices, FetchInfo12::GetParameter(invocation));

  using FetchInfo13 = InvocationToFetch<ThreadIndicesType, Invocation, 13>;
  using FetchType13 = typename FetchInfo13::type;
  FetchType13 fetch13;
  auto p13 =
    fetch13.Load(threadIndices, FetchInfo13::GetParameter(invocation));

  using FetchInfo14 = InvocationToFetch<ThreadIndicesType, Invocation, 14>;
  using FetchType14 = typename FetchInfo14::type;
  FetchType14 fetch14;
  auto p14 =
    fetch14.Load(threadIndices, FetchInfo14::GetParameter(invocation));

  using FetchInfo15 = InvocationToFetch<ThreadIndicesType, Invocation, 15>;
  using FetchType15 = typename FetchInfo15::type;
  FetchType15 fetch15;
  auto p15 =
    fetch15.Load(threadIndices, FetchInfo15::GetParameter(invocation));

  using FetchInfo16 = InvocationToFetch<ThreadIndicesType, Invocation, 16>;
  using FetchType16 = typename FetchInfo16::type;
  FetchType16 fetch16;
  auto p16 =
    fetch16.Load(threadIndices, FetchInfo16::GetParameter(invocation));

  using FetchInfo17 = InvocationToFetch<ThreadIndicesType, Invocation, 17>;
  using FetchType17 = typename FetchInfo17::type;
  FetchType17 fetch17;
  auto p17 =
    fetch17.Load(threadIndices, FetchInfo17::GetParameter(invocation));

  using FetchInfo18 = InvocationToFetch<ThreadIndicesType, Invocation, 18>;
  using FetchType18 = typename FetchInfo18::type;
  FetchType18 fetch18;
  auto p18 =
    fetch18.Load(threadIndices, FetchInfo18::GetParameter(invocation));

  using FetchInfo19 = InvocationToFetch<ThreadIndicesType, Invocation, 19>;
  using FetchType19 = typename FetchInfo19::type;
  FetchType19 fetch19;
  auto p19 =
    fetch19.Load(threadIndices, FetchInfo19::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
  fetch12.Store(threadIndices, FetchInfo12::GetParameter(invocation), p12);
  fetch13.Store(threadIndices, FetchInfo13::GetParameter(invocation), p13);
  fetch14.Store(threadIndices, FetchInfo14::GetParameter(invocation), p14);
  fetch15.Store(threadIndices, FetchInfo15::GetParameter(invocation), p15);
  fetch16.Store(threadIndices, FetchInfo16::GetParameter(invocation), p16);
  fetch17.Store(threadIndices, FetchInfo17::GetParameter(invocation), p17);
  fetch18.Store(threadIndices, FetchInfo18::GetParameter(invocation), p18);
  fetch19.Store(threadIndices, FetchInfo19::GetParameter(invocation), p19);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16,
          typename P17,
          typename P18,
          typename P19>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18, P19)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18, P19)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo12 = InvocationToFetch<ThreadIndicesType, Invocation, 12>;
  using FetchType12 = typename FetchInfo12::type;
  FetchType12 fetch12;
  auto p12 =
    fetch12.Load(threadIndices, FetchInfo12::GetParameter(invocation));

  using FetchInfo13 = InvocationToFetch<ThreadIndicesType, Invocation, 13>;
  using FetchType13 = typename FetchInfo13::type;
  FetchType13 fetch13;
  auto p13 =
    fetch13.Load(threadIndices, FetchInfo13::GetParameter(invocation));

  using FetchInfo14 = InvocationToFetch<ThreadIndicesType, Invocation, 14>;
  using FetchType14 = typename FetchInfo14::type;
  FetchType14 fetch14;
  auto p14 =
    fetch14.Load(threadIndices, FetchInfo14::GetParameter(invocation));

  using FetchInfo15 = InvocationToFetch<ThreadIndicesType, Invocation, 15>;
  using FetchType15 = typename FetchInfo15::type;
  FetchType15 fetch15;
  auto p15 =
    fetch15.Load(threadIndices, FetchInfo15::GetParameter(invocation));

  using FetchInfo16 = InvocationToFetch<ThreadIndicesType, Invocation, 16>;
  using FetchType16 = typename FetchInfo16::type;
  FetchType16 fetch16;
  auto p16 =
    fetch16.Load(threadIndices, FetchInfo16::GetParameter(invocation));

  using FetchInfo17 = InvocationToFetch<ThreadIndicesType, Invocation, 17>;
  using FetchType17 = typename FetchInfo17::type;
  FetchType17 fetch17;
  auto p17 =
    fetch17.Load(threadIndices, FetchInfo17::GetParameter(invocation));

  using FetchInfo18 = InvocationToFetch<ThreadIndicesType, Invocation, 18>;
  using FetchType18 = typename FetchInfo18::type;
  FetchType18 fetch18;
  auto p18 =
    fetch18.Load(threadIndices, FetchInfo18::GetParameter(invocation));

  using FetchInfo19 = InvocationToFetch<ThreadIndicesType, Invocation, 19>;
  using FetchType19 = typename FetchInfo19::type;
  FetchType19 fetch19;
  auto p19 =
    fetch19.Load(threadIndices, FetchInfo19::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
  fetch12.Store(threadIndices, FetchInfo12::GetParameter(invocation), p12);
  fetch13.Store(threadIndices, FetchInfo13::GetParameter(invocation), p13);
  fetch14.Store(threadIndices, FetchInfo14::GetParameter(invocation), p14);
  fetch15.Store(threadIndices, FetchInfo15::GetParameter(invocation), p15);
  fetch16.Store(threadIndices, FetchInfo16::GetParameter(invocation), p16);
  fetch17.Store(threadIndices, FetchInfo17::GetParameter(invocation), p17);
  fetch18.Store(threadIndices, FetchInfo18::GetParameter(invocation), p18);
  fetch19.Store(threadIndices, FetchInfo19::GetParameter(invocation), p19);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename R,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16,
          typename P17,
          typename P18,
          typename P19,
          typename P20>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18, P19, P20)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =  vtkm::internal::Invocation<ParameterInterface,
                                                 ControlInterface,
                                                 vtkm::internal::FunctionInterface<R(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18, P19, P20)>,
                                                 InputDomainIndex,
                                                 OutputToInputMapType,
                                                 VisitArrayType,
                                                 ThreadToOutputMapType,
                                                 DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo12 = InvocationToFetch<ThreadIndicesType, Invocation, 12>;
  using FetchType12 = typename FetchInfo12::type;
  FetchType12 fetch12;
  auto p12 =
    fetch12.Load(threadIndices, FetchInfo12::GetParameter(invocation));

  using FetchInfo13 = InvocationToFetch<ThreadIndicesType, Invocation, 13>;
  using FetchType13 = typename FetchInfo13::type;
  FetchType13 fetch13;
  auto p13 =
    fetch13.Load(threadIndices, FetchInfo13::GetParameter(invocation));

  using FetchInfo14 = InvocationToFetch<ThreadIndicesType, Invocation, 14>;
  using FetchType14 = typename FetchInfo14::type;
  FetchType14 fetch14;
  auto p14 =
    fetch14.Load(threadIndices, FetchInfo14::GetParameter(invocation));

  using FetchInfo15 = InvocationToFetch<ThreadIndicesType, Invocation, 15>;
  using FetchType15 = typename FetchInfo15::type;
  FetchType15 fetch15;
  auto p15 =
    fetch15.Load(threadIndices, FetchInfo15::GetParameter(invocation));

  using FetchInfo16 = InvocationToFetch<ThreadIndicesType, Invocation, 16>;
  using FetchType16 = typename FetchInfo16::type;
  FetchType16 fetch16;
  auto p16 =
    fetch16.Load(threadIndices, FetchInfo16::GetParameter(invocation));

  using FetchInfo17 = InvocationToFetch<ThreadIndicesType, Invocation, 17>;
  using FetchType17 = typename FetchInfo17::type;
  FetchType17 fetch17;
  auto p17 =
    fetch17.Load(threadIndices, FetchInfo17::GetParameter(invocation));

  using FetchInfo18 = InvocationToFetch<ThreadIndicesType, Invocation, 18>;
  using FetchType18 = typename FetchInfo18::type;
  FetchType18 fetch18;
  auto p18 =
    fetch18.Load(threadIndices, FetchInfo18::GetParameter(invocation));

  using FetchInfo19 = InvocationToFetch<ThreadIndicesType, Invocation, 19>;
  using FetchType19 = typename FetchInfo19::type;
  FetchType19 fetch19;
  auto p19 =
    fetch19.Load(threadIndices, FetchInfo19::GetParameter(invocation));

  using FetchInfo20 = InvocationToFetch<ThreadIndicesType, Invocation, 20>;
  using FetchType20 = typename FetchInfo20::type;
  FetchType20 fetch20;
  auto p20 =
    fetch20.Load(threadIndices, FetchInfo20::GetParameter(invocation));

  using FetchInfo0 = InvocationToFetch<ThreadIndicesType, Invocation, 0>;
  using ReturnFetchType = typename FetchInfo0::type;
  ReturnFetchType returnFetch;
  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  auto r = worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
  fetch12.Store(threadIndices, FetchInfo12::GetParameter(invocation), p12);
  fetch13.Store(threadIndices, FetchInfo13::GetParameter(invocation), p13);
  fetch14.Store(threadIndices, FetchInfo14::GetParameter(invocation), p14);
  fetch15.Store(threadIndices, FetchInfo15::GetParameter(invocation), p15);
  fetch16.Store(threadIndices, FetchInfo16::GetParameter(invocation), p16);
  fetch17.Store(threadIndices, FetchInfo17::GetParameter(invocation), p17);
  fetch18.Store(threadIndices, FetchInfo18::GetParameter(invocation), p18);
  fetch19.Store(threadIndices, FetchInfo19::GetParameter(invocation), p19);
  fetch20.Store(threadIndices, FetchInfo20::GetParameter(invocation), p20);

  returnFetch.Store(threadIndices, FetchInfo0::GetParameter(invocation), r);
}

template <typename WorkletType,
          typename ParameterInterface,
          typename ControlInterface,
          vtkm::IdComponent InputDomainIndex,
          typename OutputToInputMapType,
          typename VisitArrayType,
          typename ThreadToOutputMapType,
          typename DeviceAdapterTag,
          typename ThreadIndicesType,
          typename P1,
          typename P2,
          typename P3,
          typename P4,
          typename P5,
          typename P6,
          typename P7,
          typename P8,
          typename P9,
          typename P10,
          typename P11,
          typename P12,
          typename P13,
          typename P14,
          typename P15,
          typename P16,
          typename P17,
          typename P18,
          typename P19,
          typename P20>
VTKM_EXEC void DoWorkletInvokeFunctor(
  const WorkletType& worklet,
  const vtkm::internal::Invocation<ParameterInterface,
                                   ControlInterface,
                                   vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18, P19, P20)>,
                                   InputDomainIndex,
                                   OutputToInputMapType,
                                   VisitArrayType,
                                   ThreadToOutputMapType,
                                   DeviceAdapterTag>& invocation,
  const ThreadIndicesType& threadIndices)
{
  using Invocation =
    vtkm::internal::Invocation<ParameterInterface,
                               ControlInterface,
                               vtkm::internal::FunctionInterface<void(P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18, P19, P20)>,
                               InputDomainIndex,
                               OutputToInputMapType,
                               VisitArrayType,
                               ThreadToOutputMapType,
                               DeviceAdapterTag>;

  using FetchInfo1 = InvocationToFetch<ThreadIndicesType, Invocation, 1>;
  using FetchType1 = typename FetchInfo1::type;
  FetchType1 fetch1;
  auto p1 =
    fetch1.Load(threadIndices, FetchInfo1::GetParameter(invocation));

  using FetchInfo2 = InvocationToFetch<ThreadIndicesType, Invocation, 2>;
  using FetchType2 = typename FetchInfo2::type;
  FetchType2 fetch2;
  auto p2 =
    fetch2.Load(threadIndices, FetchInfo2::GetParameter(invocation));

  using FetchInfo3 = InvocationToFetch<ThreadIndicesType, Invocation, 3>;
  using FetchType3 = typename FetchInfo3::type;
  FetchType3 fetch3;
  auto p3 =
    fetch3.Load(threadIndices, FetchInfo3::GetParameter(invocation));

  using FetchInfo4 = InvocationToFetch<ThreadIndicesType, Invocation, 4>;
  using FetchType4 = typename FetchInfo4::type;
  FetchType4 fetch4;
  auto p4 =
    fetch4.Load(threadIndices, FetchInfo4::GetParameter(invocation));

  using FetchInfo5 = InvocationToFetch<ThreadIndicesType, Invocation, 5>;
  using FetchType5 = typename FetchInfo5::type;
  FetchType5 fetch5;
  auto p5 =
    fetch5.Load(threadIndices, FetchInfo5::GetParameter(invocation));

  using FetchInfo6 = InvocationToFetch<ThreadIndicesType, Invocation, 6>;
  using FetchType6 = typename FetchInfo6::type;
  FetchType6 fetch6;
  auto p6 =
    fetch6.Load(threadIndices, FetchInfo6::GetParameter(invocation));

  using FetchInfo7 = InvocationToFetch<ThreadIndicesType, Invocation, 7>;
  using FetchType7 = typename FetchInfo7::type;
  FetchType7 fetch7;
  auto p7 =
    fetch7.Load(threadIndices, FetchInfo7::GetParameter(invocation));

  using FetchInfo8 = InvocationToFetch<ThreadIndicesType, Invocation, 8>;
  using FetchType8 = typename FetchInfo8::type;
  FetchType8 fetch8;
  auto p8 =
    fetch8.Load(threadIndices, FetchInfo8::GetParameter(invocation));

  using FetchInfo9 = InvocationToFetch<ThreadIndicesType, Invocation, 9>;
  using FetchType9 = typename FetchInfo9::type;
  FetchType9 fetch9;
  auto p9 =
    fetch9.Load(threadIndices, FetchInfo9::GetParameter(invocation));

  using FetchInfo10 = InvocationToFetch<ThreadIndicesType, Invocation, 10>;
  using FetchType10 = typename FetchInfo10::type;
  FetchType10 fetch10;
  auto p10 =
    fetch10.Load(threadIndices, FetchInfo10::GetParameter(invocation));

  using FetchInfo11 = InvocationToFetch<ThreadIndicesType, Invocation, 11>;
  using FetchType11 = typename FetchInfo11::type;
  FetchType11 fetch11;
  auto p11 =
    fetch11.Load(threadIndices, FetchInfo11::GetParameter(invocation));

  using FetchInfo12 = InvocationToFetch<ThreadIndicesType, Invocation, 12>;
  using FetchType12 = typename FetchInfo12::type;
  FetchType12 fetch12;
  auto p12 =
    fetch12.Load(threadIndices, FetchInfo12::GetParameter(invocation));

  using FetchInfo13 = InvocationToFetch<ThreadIndicesType, Invocation, 13>;
  using FetchType13 = typename FetchInfo13::type;
  FetchType13 fetch13;
  auto p13 =
    fetch13.Load(threadIndices, FetchInfo13::GetParameter(invocation));

  using FetchInfo14 = InvocationToFetch<ThreadIndicesType, Invocation, 14>;
  using FetchType14 = typename FetchInfo14::type;
  FetchType14 fetch14;
  auto p14 =
    fetch14.Load(threadIndices, FetchInfo14::GetParameter(invocation));

  using FetchInfo15 = InvocationToFetch<ThreadIndicesType, Invocation, 15>;
  using FetchType15 = typename FetchInfo15::type;
  FetchType15 fetch15;
  auto p15 =
    fetch15.Load(threadIndices, FetchInfo15::GetParameter(invocation));

  using FetchInfo16 = InvocationToFetch<ThreadIndicesType, Invocation, 16>;
  using FetchType16 = typename FetchInfo16::type;
  FetchType16 fetch16;
  auto p16 =
    fetch16.Load(threadIndices, FetchInfo16::GetParameter(invocation));

  using FetchInfo17 = InvocationToFetch<ThreadIndicesType, Invocation, 17>;
  using FetchType17 = typename FetchInfo17::type;
  FetchType17 fetch17;
  auto p17 =
    fetch17.Load(threadIndices, FetchInfo17::GetParameter(invocation));

  using FetchInfo18 = InvocationToFetch<ThreadIndicesType, Invocation, 18>;
  using FetchType18 = typename FetchInfo18::type;
  FetchType18 fetch18;
  auto p18 =
    fetch18.Load(threadIndices, FetchInfo18::GetParameter(invocation));

  using FetchInfo19 = InvocationToFetch<ThreadIndicesType, Invocation, 19>;
  using FetchType19 = typename FetchInfo19::type;
  FetchType19 fetch19;
  auto p19 =
    fetch19.Load(threadIndices, FetchInfo19::GetParameter(invocation));

  using FetchInfo20 = InvocationToFetch<ThreadIndicesType, Invocation, 20>;
  using FetchType20 = typename FetchInfo20::type;
  FetchType20 fetch20;
  auto p20 =
    fetch20.Load(threadIndices, FetchInfo20::GetParameter(invocation));

  // If you got a compile error on the following line, it probably means that
  // the operator() of a worklet does not match the definition expected. One
  // common problem is that the operator() method must be declared const. Check
  // to make sure the "const" keyword is after parameters. Another common
  // problem is that the type of one or more parameters is incompatible with
  // the actual type that VTK-m creates in the execution environment. Make sure
  // that the types of the worklet operator() parameters match those in the
  // ExecutionSignature. The compiler error might help you narrow down which
  // parameter is wrong and the types that did not match.
  worklet(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20);

  fetch1.Store(threadIndices, FetchInfo1::GetParameter(invocation), p1);
  fetch2.Store(threadIndices, FetchInfo2::GetParameter(invocation), p2);
  fetch3.Store(threadIndices, FetchInfo3::GetParameter(invocation), p3);
  fetch4.Store(threadIndices, FetchInfo4::GetParameter(invocation), p4);
  fetch5.Store(threadIndices, FetchInfo5::GetParameter(invocation), p5);
  fetch6.Store(threadIndices, FetchInfo6::GetParameter(invocation), p6);
  fetch7.Store(threadIndices, FetchInfo7::GetParameter(invocation), p7);
  fetch8.Store(threadIndices, FetchInfo8::GetParameter(invocation), p8);
  fetch9.Store(threadIndices, FetchInfo9::GetParameter(invocation), p9);
  fetch10.Store(threadIndices, FetchInfo10::GetParameter(invocation), p10);
  fetch11.Store(threadIndices, FetchInfo11::GetParameter(invocation), p11);
  fetch12.Store(threadIndices, FetchInfo12::GetParameter(invocation), p12);
  fetch13.Store(threadIndices, FetchInfo13::GetParameter(invocation), p13);
  fetch14.Store(threadIndices, FetchInfo14::GetParameter(invocation), p14);
  fetch15.Store(threadIndices, FetchInfo15::GetParameter(invocation), p15);
  fetch16.Store(threadIndices, FetchInfo16::GetParameter(invocation), p16);
  fetch17.Store(threadIndices, FetchInfo17::GetParameter(invocation), p17);
  fetch18.Store(threadIndices, FetchInfo18::GetParameter(invocation), p18);
  fetch19.Store(threadIndices, FetchInfo19::GetParameter(invocation), p19);
  fetch20.Store(threadIndices, FetchInfo20::GetParameter(invocation), p20);
}

// clang-format on
}
}
}
} // namespace vtkm::exec::internal::detail

#endif //vtk_m_exec_internal_WorkletInvokeFunctorDetail_h
