#pragma once

#include "vtkFiltersTemporalModule.h" // For export macro

#include "vtkPassInputTypeAlgorithm.h"

// TODO: Consider making this generic on vtkDataSet

class vtkLinearTransform;
class vtkTransform;
class vtkDataSet;

class VTK_EXPORT vtkContinuousPointRegistration : public vtkPassInputTypeAlgorithm
{
public:
  static vtkContinuousPointRegistration* New();
  vtkTypeMacro(vtkContinuousPointRegistration, vtkPassInputTypeAlgorithm);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  //@{
  /**
   * Transform the output using @ref
   * vtkTransformDataSetFilter. Points, Normals and Vectors are
   * transformed (default=ON).
   */
  vtkSetMacro(ExplicitTransform, vtkTypeBool);
  vtkGetMacro(ExplicitTransform, vtkTypeBool);
  vtkBooleanMacro(ExplicitTransform, vtkTypeBool);
  //@}

  //@{
  /**
   * Use temporal registration. The module will continue execution
   * until two successive data are registered (default=ON).
   */
  vtkSetMacro(TemporalRegistration, vtkTypeBool);
  vtkGetMacro(TemporalRegistration, vtkTypeBool);
  vtkBooleanMacro(TemporalRegistration, vtkTypeBool);
  //@}

  ///@{
  /**
   * Set/Get the algorithm used for registration.
   */
  virtual void SetRegistrationAlgorithm(vtkLinearTransform*);
  vtkGetObjectMacro(RegistrationAlgorithm, vtkLinearTransform);
  ///@}

  ///@{
  /**
   * Whether or not to deep copy the input. This can be useful if you
   * want to create a copy of a data object. You can then disconnect
   * this filter's input connections and it will act like a source.
   * Defaults to OFF.
   */
  vtkSetMacro(DeepCopyInput, vtkTypeBool);
  vtkGetMacro(DeepCopyInput, vtkTypeBool);
  vtkBooleanMacro(DeepCopyInput, vtkTypeBool);
  ///@}

  virtual void SetLastTarget(vtkDataSet* lastTarget);
  vtkGetObjectMacro(LastTarget, vtkDataSet);

protected:
  vtkContinuousPointRegistration();
  ~vtkContinuousPointRegistration() override;

  void ReleaseLastTarget();

  // RequestDataObject - inherited

  int RequestInformation(vtkInformation* request, vtkInformationVector** inputVector,
    vtkInformationVector* outputVector);

  int RequestUpdateTime(vtkInformation* request, vtkInformationVector** inputVector,
    vtkInformationVector* outputVector);

  int RequestUpdateTimeDependentInformation(vtkInformation* request,
    vtkInformationVector** inputVector, vtkInformationVector* outputVector);

  int RequestUpdateExtent(vtkInformation* request, vtkInformationVector** inputVector,
    vtkInformationVector* outputVector);

  int RequestData(vtkInformation* request, vtkInformationVector** inputVector,
    vtkInformationVector* outputVector);

  vtkLinearTransform* RegistrationAlgorithm;
  vtkDataSet* LastTarget;
  vtkTypeBool ExplicitTransform;
  vtkTypeBool TemporalRegistration;
  vtkTypeBool DeepCopyInput;

  void CreateDefaultRegistration();

private:
  vtkContinuousPointRegistration(const vtkContinuousPointRegistration&) = delete;
  void operator=(const vtkContinuousPointRegistration&) = delete;
  vtkTransform* UserTransform;
  double* TimeSteps;
  int NTimeSteps;
  int TimeStepIndex;
  double TimeStep;
};
