/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.j3d.terrain.AbstractTerrainData;
import org.j3d.terrain.TextureTileGenerator;
import org.j3d.terrain.TiledTerrainData;

public abstract class AbstractTiledTerrainData
extends AbstractTerrainData
implements TiledTerrainData {
    protected TextureTileGenerator tileGenerator;
    protected int gridPointsPerTile;
    private int widthPixelsPerGridStep;
    private int depthPixelsPerGridStep;
    private Rectangle pixelBounds;

    protected AbstractTiledTerrainData() {
        super(2);
        this.colorAvailable = false;
        this.textureAvailable = false;
    }

    public int getTileSize() {
        return this.gridPointsPerTile;
    }

    public BufferedImage getTexture(int n, int n2) {
        BufferedImage bufferedImage = null;
        if (this.tileGenerator != null) {
            int n3 = this.convertTileToGridCoord(n += 2);
            int n4 = this.convertTileToGridCoord(++n2);
            this.pixelBounds.x = n3 * this.widthPixelsPerGridStep;
            this.pixelBounds.y = n4 * this.depthPixelsPerGridStep;
            bufferedImage = this.tileGenerator.getTextureTile(this.pixelBounds);
            this.textureAvailable = true;
        }
        return bufferedImage;
    }

    public void setTextureTileGenerator(TextureTileGenerator textureTileGenerator) {
        this.tileGenerator = textureTileGenerator;
        if (textureTileGenerator != null) {
            if (this.pixelBounds == null) {
                this.pixelBounds = new Rectangle();
            }
            Dimension dimension = textureTileGenerator.getTextureSize();
            this.widthPixelsPerGridStep = dimension.width / this.gridPointsPerTile;
            this.depthPixelsPerGridStep = dimension.height / this.gridPointsPerTile;
            this.pixelBounds.width = dimension.width;
            this.pixelBounds.height = dimension.height;
        }
    }

    protected int convertTileToGridCoord(int n) {
        return n * this.gridPointsPerTile;
    }

    protected int convertGridToTileCoord(int n) {
        return n / this.gridPointsPerTile;
    }
}

