/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/

#include "stdafx.h"
#include "patient/conditions/SEMitralValveInsufficiency.h"
#include "properties/SEScalar0To1.h"
PROTO_PUSH
#include "bind/cdm/PatientConditions.pb.h"
PROTO_POP

SEMitralValveInsufficiency::SEMitralValveInsufficiency() : SEPatientCondition()
{
	m_Severity = nullptr;
}

SEMitralValveInsufficiency::~SEMitralValveInsufficiency()
{
	Clear();
}

void SEMitralValveInsufficiency::Clear()
{
	SEPatientCondition::Clear();
	SAFE_DELETE(m_Severity);
}

bool SEMitralValveInsufficiency::IsValid() const
{
	return SEPatientCondition::IsValid() && HasSeverity();
}

void SEMitralValveInsufficiency::Load(const cdm::MitralValveInsufficiencyData& src, SEMitralValveInsufficiency& dst)
{
	SEMitralValveInsufficiency::Serialize(src, dst);
}
void SEMitralValveInsufficiency::Serialize(const cdm::MitralValveInsufficiencyData& src, SEMitralValveInsufficiency& dst)
{
	SEPatientCondition::Serialize(src.patientcondition(), dst);
	if (src.has_severity())
		SEScalar0To1::Load(src.severity(), dst.GetSeverity());
}

cdm::MitralValveInsufficiencyData* SEMitralValveInsufficiency::Unload(const SEMitralValveInsufficiency& src)
{
	cdm::MitralValveInsufficiencyData* dst = new cdm::MitralValveInsufficiencyData();
	SEMitralValveInsufficiency::Serialize(src, *dst);
	return dst;
}
void SEMitralValveInsufficiency::Serialize(const SEMitralValveInsufficiency& src, cdm::MitralValveInsufficiencyData& dst)
{
	SEPatientCondition::Serialize(src, *dst.mutable_patientcondition());
	if (src.HasSeverity())
		dst.set_allocated_severity(SEScalar0To1::Unload(*src.m_Severity));
}

bool SEMitralValveInsufficiency::HasSeverity() const
{
	return m_Severity == nullptr ? false : m_Severity->IsValid();
}

SEScalar0To1& SEMitralValveInsufficiency::GetSeverity()
{
	if (m_Severity == nullptr)
		m_Severity = new SEScalar0To1();
	return *m_Severity;
}

void SEMitralValveInsufficiency::ToString(std::ostream &str) const
{
	str << "Patient Condition : Mitral Valve Insufficiency";
	if (HasComment())
		str << "\n\tComment: " << m_Comment;
	str << "\n\tSeverity: "; HasSeverity() ? str << m_Severity : str << "NaN";
	str << std::flush;
}