/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/

#pragma once
#include "patient/conditions/SEPatientCondition.h"
CDM_BIND_DECL(AorticStenosisData)

class CDM_DECL SEAorticStenosis : public SEPatientCondition
{
public:

	SEAorticStenosis();
	virtual ~SEAorticStenosis();

	virtual void Clear(); //clear memory

	virtual bool IsValid() const;

	static void Load(const cdm::AorticStenosisData& src, SEAorticStenosis& dst);
	static cdm::AorticStenosisData* Unload(const SEAorticStenosis& src);
protected:
	static void Serialize(const cdm::AorticStenosisData& src, SEAorticStenosis& dst);
	static void Serialize(const SEAorticStenosis& src, cdm::AorticStenosisData& dst);

public:
	virtual std::string GetName() const { return "AorticStenosis"; }

	virtual bool HasSeverity() const;
	virtual SEScalar0To1& GetSeverity();

	virtual void ToString(std::ostream &str) const;

protected:
	SEScalar0To1*           m_Severity;
};
