/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/

#pragma once
#include "patient/conditions/SEPatientCondition.h"
CDM_BIND_DECL(AorticRegurgitationData)

class CDM_DECL SEAorticRegurgitation : public SEPatientCondition
{
public:

	SEAorticRegurgitation();
	virtual ~SEAorticRegurgitation();

	virtual void Clear(); //clear memory

	virtual bool IsValid() const;

	static void Load(const cdm::AorticRegurgitationData& src, SEAorticRegurgitation& dst);
	static cdm::AorticRegurgitationData* Unload(const SEAorticRegurgitation& src);
protected:
	static void Serialize(const cdm::AorticRegurgitationData& src, SEAorticRegurgitation& dst);
	static void Serialize(const SEAorticRegurgitation& src, cdm::AorticRegurgitationData& dst);

public:
	virtual std::string GetName() const { return "AorticRegurgitation"; }

	virtual bool HasSeverity() const;
	virtual SEScalar0To1& GetSeverity();

	virtual void ToString(std::ostream &str) const;

protected:
	SEScalar0To1*           m_Severity;
};
