"""The main module for command line program "demodock"."""

import argparse
import demodock
import os
import sys


def demodock_up(args):
    """demodock up subcommand."""
    path = os.path.abspath(args.root)
    print path
    print args.port


def demodock_down(args):
    """demodock down subcommand."""
    print "down"


def demodock_build(args):
    """demodock build subcommand."""
    path = os.path.abspath(args.path)
    print path
    print args.name


def demodock_shell(args):
    """demodock shell subcommand."""
    print "shell"


def demodock_start(args):
    """demodock start subcommand."""
    print args.image
    print args.name


def demodock_stop(args):
    """demodock stop subcommand."""
    print args.container


def demodock_update(args):
    """demodock update subcommand."""
    print "update"


def demodock_ps(args):
    """demodock ps subcommand."""
    lines = demodock.docker_ps_lines()
    print "\n".join(lines)


def main():
    """Implementation of "demodock" command line utility."""
    # Top-level commandline parser.
    parser = argparse.ArgumentParser(prog="demodock", description="DemoDock: Docker-based demos, served with Nginx")
    subparsers = parser.add_subparsers()

    # Parser for "up" subcommand.
    help_string = "Start a demodock server instance"
    p = subparsers.add_parser("up", description=help_string, help=help_string)
    p.add_argument("--root", "-r", default=".", metavar="WEBROOT", help="Path to directory to be served by demodock (default: current directory)")
    p.add_argument("--port", "-p", default=80, type=int, metavar="PORT", help="Port to serve demodock on (default: 80)")
    p.set_defaults(func=demodock_up)

    # Parser for "down" subcommand.
    help_string = "Stop a running demodock server instance"
    p = subparsers.add_parser("down", description=help_string, help=help_string)
    p.set_defaults(func=demodock_down)

    # Parser for "build" subcommand.
    help_string = "Build a demo container"
    p = subparsers.add_parser("build", description=help_string, help=help_string)
    p.add_argument("name", metavar="name", help="Name of the image to build")
    p.add_argument("path", nargs="?", default=".", metavar="dir", help="Directory holding Dockerfile (default: current directory)")
    p.set_defaults(func=demodock_build)

    # Parser for "shell" subcommand.
    help_string = "Run a shell in the last successfully built container"
    p = subparsers.add_parser("shell", description=help_string, help=help_string)
    p.set_defaults(func=demodock_shell)

    # Parser for "start" subcommand.
    help_string = "Start a demo container"
    p = subparsers.add_parser("start", description=help_string, help=help_string)
    p.add_argument("image", metavar="image", help="The demodock image to launch")
    p.add_argument("name", nargs="?", help="The name of the new container (default: image name + timestamp)")
    p.set_defaults(func=demodock_start)

    # Parser for "stop" subcommand.
    help_string = "Stop a demo container"
    p = subparsers.add_parser("stop", description=help_string, help=help_string)
    p.add_argument("container", metavar="container_id", help="The container ID or image name to stop")
    p.set_defaults(func=demodock_stop)

    # Parser for "update" subcommand.
    help_string = "Update server with refreshed list of running demos"
    p = subparsers.add_parser("update", description=help_string, help=help_string)
    p.set_defaults(func=demodock_update)

    # Parser for "ps" subcommand.
    help_string = "Examine running demo containers"
    p = subparsers.add_parser("ps", description=help_string, help=help_string)
    p.set_defaults(func=demodock_ps)

    # Run the parser on the actual command line.
    args = parser.parse_args()
    args.func(args)


if __name__ == "__main__":
    sys.exit(main())
