/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer;

import java.util.HashMap;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.SceneGraphTraversalSimpleObserver;
import org.web3d.vrml.nodes.VRMLExternalNodeType;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.proto.ProtoScene;

public class NodeCopier
implements SceneGraphTraversalSimpleObserver {
    private VRMLNodeFactory factory;
    private ProtoScene scene;
    private HashMap nodeMap;
    private VRMLNodeType srcNode;
    private VRMLExecutionSpace parentSpace;
    private String worldURL;
    private int majorVersion;
    private int minorVersion;
    private boolean staticNodes;
    private ErrorReporter errorReporter;

    NodeCopier(VRMLNodeFactory vRMLNodeFactory, String string) {
        if (vRMLNodeFactory == null) {
            throw new NullPointerException("No node factory supplied");
        }
        this.factory = vRMLNodeFactory;
        this.nodeMap = new HashMap();
        this.worldURL = string;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    VRMLNodeType copyNode(VRMLNodeType vRMLNodeType, ProtoScene protoScene, VRMLExecutionSpace vRMLExecutionSpace, int n, int n2, boolean bl) {
        if (protoScene == null) {
            throw new NullPointerException("No scene supplied");
        }
        if (vRMLExecutionSpace == null) {
            throw new NullPointerException("No execution space supplied");
        }
        this.scene = protoScene;
        this.srcNode = vRMLNodeType;
        this.parentSpace = vRMLExecutionSpace;
        this.majorVersion = n;
        this.minorVersion = n2;
        this.staticNodes = bl;
        VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.factory.createVRMLNode(vRMLNodeType, bl);
        this.nodeMap.put(vRMLNodeType, vRMLNodeType2);
        return vRMLNodeType2;
    }

    public void observedNode(VRMLNodeType vRMLNodeType, VRMLNodeType vRMLNodeType2, int n, boolean bl) {
        VRMLNodeType vRMLNodeType3;
        if (bl) {
            vRMLNodeType3 = (VRMLNodeType)this.nodeMap.get(vRMLNodeType2);
            if (!vRMLNodeType3.isDEF()) {
                vRMLNodeType3.setDEF();
            }
        } else if (!(vRMLNodeType2 instanceof VRMLProtoInstance)) {
            vRMLNodeType3 = (VRMLNodeType)this.factory.createVRMLNode(vRMLNodeType2, this.staticNodes);
            this.nodeMap.put(vRMLNodeType2, vRMLNodeType3);
            if (vRMLNodeType3 instanceof VRMLInlineNodeType) {
                ((VRMLInlineNodeType)vRMLNodeType3).setParentSpace(this.parentSpace);
            } else if (vRMLNodeType3 instanceof VRMLScriptNodeType) {
                ((VRMLScriptNodeType)vRMLNodeType3).setExecutionSpace(this.parentSpace);
            }
            if (vRMLNodeType3 instanceof VRMLExternalNodeType) {
                ((VRMLExternalNodeType)((Object)vRMLNodeType3)).setWorldUrl(this.worldURL);
            }
        } else {
            this.scene.addNode(vRMLNodeType2);
            vRMLNodeType3 = vRMLNodeType2;
            this.nodeMap.put(vRMLNodeType2, vRMLNodeType3);
        }
        if (vRMLNodeType == null) {
            return;
        }
        VRMLNodeType vRMLNodeType4 = (VRMLNodeType)this.nodeMap.get(vRMLNodeType);
        VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(n);
        int n2 = vRMLNodeType4.getFieldIndex(vRMLFieldDeclaration.getName());
        try {
            vRMLNodeType4.setValue(n2, vRMLNodeType3);
        }
        catch (FieldException fieldException) {
            this.errorReporter.warningReport("NodeCopier error", fieldException);
        }
    }
}

