// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

#include "vtkChartXY.h"
#include "vtkContextScene.h"
#include "vtkContextView.h"
#include "vtkFloatArray.h"
#include "vtkNew.h"
#include "vtkPlotPoints.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkSmartPointer.h"
#include "vtkTable.h"

#include <string>

#include <iostream>

static constexpr int NPOINTS = 65;
static constexpr float INCX = 7.5;

//------------------------------------------------------------------------------
int TestPlotPoints(int, char*[])
{
  int status = EXIT_SUCCESS;
  // Set up a 2D scene, add an XY chart to it
  vtkNew<vtkContextView> view;
  view->GetRenderWindow()->SetSize(400, 300);
  vtkNew<vtkChartXY> chart;
  view->GetScene()->AddItem(chart);

  // Create a table with some points in it...
  vtkNew<vtkTable> table;
  vtkNew<vtkFloatArray> arrX;
  arrX->SetName("X Axis");
  table->AddColumn(arrX);
  vtkNew<vtkFloatArray> arrC;
  arrC->SetName("Cosine");
  table->AddColumn(arrC);
  vtkNew<vtkFloatArray> arrS;
  arrS->SetName("Sine");
  table->AddColumn(arrS);
  // Test charting with a few more points...
  const float inc = INCX / (NPOINTS - 1);
  table->SetNumberOfRows(NPOINTS);
  for (int i = 0; i < NPOINTS; ++i)
  {
    table->SetValue(i, 0, i * inc);
    table->SetValue(i, 1, cos(i * inc) + 0.0);
    table->SetValue(i, 2, sin(i * inc) + 0.0);
  }

  // Add a plot containing points
  vtkPlotPoints* points = vtkPlotPoints::SafeDownCast(chart->AddPlot(vtkChart::POINTS));
  points->SetInputData(table, 0, 1); // start by displaying the cosine function
  points->SetColor(255, 0, 0);
  view->Render();

  // Test that graphics cache is properly released when changing the data for the plot
  points->SetInputArray(1, "Sine"); // we want to display the sine function instead

  // Render the scene and compare the image to a reference image
  view->GetRenderWindow()->SetMultiSamples(0);
  view->GetInteractor()->Initialize();
  view->GetInteractor()->Start();

  return status;
}
