# Async ParaView

## Introduction
This project aims to improve responsiveness and
user experience of [ParaView][paraview-master] with asynchronous execution of
data-processing, rendering and client application.

The async paraview library enables domain-specific, responsive visualization
applications which do not stall during data processing or rendering.
It uses existing concepts of [ParaView][paraview-master] server manager -
proxies, pipelines, domains, properties, views, representations combined with asynchronous services.

## Async ParaView Library
The library allows rapid prototyping of ideas and offers a rich API for developer interactions
with `ServerManager`. The application state resides in the
`ServerManager` whereas, application logic no longer sits in a
monolithic core as in [ParaView][paraview-master]; instead, portable and
reusable modules called `Microservices` implement the business logic.

As it is over-ambitious to achieve full feature-parity with existing [ParaView][paraview-master],
the library is designed to support a smaller feature-set that
would enable rapid development of small domain-specific web/desktop applications through [trame][].

[paraview-master]: https://gitlab.kitware.com/paraview/paraview.git
[trame]: https://kitware.github.io/trame/index.html

## Building
The easiest method for beginners to build ParaView from source is
by using our [Getting Started compilation guide][build] which includes
commands to install the needed dependencies for Linux and MacOS.

[build]: BuildAsync.md

## Examples
Visit [paraview-async-examples][] to look at prototype trame-based web applications using the asynchronous
paraview library.

[paraview-async-examples]: https://gitlab.kitware.com/async/paraview-async-examples.git

## Reporting Bugs
If you have found a bug:

1. If you have a source-code fix, please read the [CONTRIBUTING.md][] document.

2. If the issue is not resolved by the above steps, open
   an entry in the [Async ParaView Issue Tracker][].

[CONTRIBUTING.md]: CONTRIBUTING.md
[Async ParaView Issue Tracker]: https://gitlab.kitware.com/async/paraview/-/issues

## Contributing
See [CONTRIBUTING.md][] for instructions to contribute.

[CONTRIBUTING.md]: CONTRIBUTING.md

## License

ParaView is distributed under the OSI-approved BSD 3-clause License.
See [Copyright.txt][] for details. For additional licenses, refer to
[ParaView Licenses][].

[Copyright.txt]: Copyright.txt
[ParaView Licenses]: http://www.paraview.org/paraview-license/
