# Build Intructions for ParaView Async

## Initialize repository
```
git clone git@gitlab.kitware.com:async/paraview.git
cd paraview
git submodule update --init --recursive
cd -
```

## Setup mochi-thallium

### Setup spack
```
git clone https://github.com/spack/spack.git
export SPACK_ROOT=$PWD/spack
. ./spack/share/spack/setup-env.sh
```

### Mochi-thallium
```
git clone https://github.com/mochi-hpc/mochi-spack-packages.git
spack repo add mochi-spack-packages
spack install mochi-thallium@0.10.1 ^libfabric fabrics=tcp,rxm,sockets ^mochi-margo@0.9.10 ^mercury@2.2.0 ^argobots@dce6e727ffc4ca5b3ffc04cb9517c6689be51ec5=main
```
If there are issues with `libfabric` on other platforms try with `fabrics=sockets`.

## Image delivery

### Software based:
`nasm` and `perl` are needed to build the `libvpx` codec sdk for VP9 encoder and decoder.
You may download `nasm` from https://www.nasm.us/ or your distribution package manager. `perl`
is usually installed by default.

### Hardware Accelerated (nvidia):
- Build dependency: none
- Runtime dependency: An NVIDIA GPU with NVENC capabilities and a working nvidia driver.
Please visit https://developer.nvidia.com/video-encode-and-decode-gpu-support-matrix-new to check
if your GPU is supported.

## Build
```
export SPACK_ROOT=$PWD/spack
. ./spack/share/spack/setup-env.sh
spack load mochi-thallium

cmake -G Ninja \
    -S ./paraview \
    -B ./build \
    -D PARAVIEW_BUILD_TESTING=WANT \
    -D PARAVIEW_USE_PYTHON=ON \
    -D PARAVIEW_USE_QT=OFF \
    -D PARAVIEW_USE_VTKM=OFF
```

## Extras

### Python
For python support add `-DPARAVIEW_USE_PYTHON=ON`.
`pvpython` can be used to run python scripts and applications.
If `python` is preferred, set environment variable to ensure its picked up by `python`.
```bash
export PYTHONPATH=./build/lib/pythonx.y/site-packages
```

### Ospray [experimental]
For raytracing [get](https://github.com/ospray/ospray/releases/tag/v2.9.0) ospray binaries and set
`-DPARAVIEW_ENABLE_RAYTRACING=ON` and  `-Dospray_DIR` to the appropriate location. For Linux  it
is  `-Dospray_DIR="<extracted location>/ospray-2.9.0.x86_64.linux/lib/cmake/ospray-2.9.0"`.
When running any application utilizing raytracing you may need to update the library path. For Linux:
`export LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:<extracted location>/ospray-2.9.0.x86_64.linux/lib/`

### Qt [experimental]
For the desktop qt client, set `-DPARAVIEW_USE_QT=ON` in the cmake configure step. The Qt client
is functional, although many features are not enabled and certain buttons, actions may crash the application.

### MPI [experimental]
Set `-DPARAVIEW_USE_MPI=ON` in the cmake configure step. The MPI environment
is untested.
